/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.metamodel.cif.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StdLibFunction implements Enumerator
{
    MINIMUM(1, "Minimum", "Minimum"),
    MAXIMUM(2, "Maximum", "Maximum"),
    POWER(3, "Power", "Power"),
    SIGN(4, "Sign", "Sign"),
    CBRT(5, "Cbrt", "Cbrt"),
    CEIL(6, "Ceil", "Ceil"),
    DELETE(7, "Delete", "Delete"),
    EMPTY(8, "Empty", "Empty"),
    EXP(9, "Exp", "Exp"),
    FLOOR(10, "Floor", "Floor"),
    LN(15, "Ln", "Ln"),
    LOG(16, "Log", "Log"),
    POP(17, "Pop", "Pop"),
    ROUND(19, "Round", "Round"),
    SIZE(13, "Size", "Size"),
    SQRT(22, "Sqrt", "Sqrt"),
    ACOSH(23, "Acosh", "Acosh"),
    ACOS(24, "Acos", "Acos"),
    ASINH(25, "Asinh", "Asinh"),
    ASIN(26, "Asin", "Asin"),
    ATANH(27, "Atanh", "Atanh"),
    ATAN(28, "Atan", "Atan"),
    COSH(29, "Cosh", "Cosh"),
    COS(30, "Cos", "Cos"),
    SINH(31, "Sinh", "Sinh"),
    SIN(32, "Sin", "Sin"),
    TANH(33, "Tanh", "Tanh"),
    TAN(34, "Tan", "Tan"),
    ABS(0, "Abs", "Abs"),
    BERNOULLI(35, "Bernoulli", "Bernoulli"),
    BETA(36, "Beta", "Beta"),
    BINOMIAL(37, "Binomial", "Binomial"),
    CONSTANT(38, "Constant", "Constant"),
    ERLANG(39, "Erlang", "Erlang"),
    EXPONENTIAL(40, "Exponential", "Exponential"),
    GAMMA(41, "Gamma", "Gamma"),
    GEOMETRIC(42, "Geometric", "Geometric"),
    LOG_NORMAL(43, "LogNormal", "LogNormal"),
    NORMAL(44, "Normal", "Normal"),
    POISSON(45, "Poisson", "Poisson"),
    RANDOM(46, "Random", "Random"),
    TRIANGLE(47, "Triangle", "Triangle"),
    UNIFORM(48, "Uniform", "Uniform"),
    WEIBULL(49, "Weibull", "Weibull"),
    FORMAT(11, "Format", "Format"),
    SCALE(12, "Scale", "Scale");

    public static final int MINIMUM_VALUE = 1;
    public static final int MAXIMUM_VALUE = 2;
    public static final int POWER_VALUE = 3;
    public static final int SIGN_VALUE = 4;
    public static final int CBRT_VALUE = 5;
    public static final int CEIL_VALUE = 6;
    public static final int DELETE_VALUE = 7;
    public static final int EMPTY_VALUE = 8;
    public static final int EXP_VALUE = 9;
    public static final int FLOOR_VALUE = 10;
    public static final int LN_VALUE = 15;
    public static final int LOG_VALUE = 16;
    public static final int POP_VALUE = 17;
    public static final int ROUND_VALUE = 19;
    public static final int SIZE_VALUE = 13;
    public static final int SQRT_VALUE = 22;
    public static final int ACOSH_VALUE = 23;
    public static final int ACOS_VALUE = 24;
    public static final int ASINH_VALUE = 25;
    public static final int ASIN_VALUE = 26;
    public static final int ATANH_VALUE = 27;
    public static final int ATAN_VALUE = 28;
    public static final int COSH_VALUE = 29;
    public static final int COS_VALUE = 30;
    public static final int SINH_VALUE = 31;
    public static final int SIN_VALUE = 32;
    public static final int TANH_VALUE = 33;
    public static final int TAN_VALUE = 34;
    public static final int ABS_VALUE = 0;
    public static final int BERNOULLI_VALUE = 35;
    public static final int BETA_VALUE = 36;
    public static final int BINOMIAL_VALUE = 37;
    public static final int CONSTANT_VALUE = 38;
    public static final int ERLANG_VALUE = 39;
    public static final int EXPONENTIAL_VALUE = 40;
    public static final int GAMMA_VALUE = 41;
    public static final int GEOMETRIC_VALUE = 42;
    public static final int LOG_NORMAL_VALUE = 43;
    public static final int NORMAL_VALUE = 44;
    public static final int POISSON_VALUE = 45;
    public static final int RANDOM_VALUE = 46;
    public static final int TRIANGLE_VALUE = 47;
    public static final int UNIFORM_VALUE = 48;
    public static final int WEIBULL_VALUE = 49;
    public static final int FORMAT_VALUE = 11;
    public static final int SCALE_VALUE = 12;
    private static final StdLibFunction[] VALUES_ARRAY;
    public static final List<StdLibFunction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StdLibFunction[]{MINIMUM, MAXIMUM, POWER, SIGN, CBRT, CEIL, DELETE, EMPTY, EXP, FLOOR, LN, LOG, POP, ROUND, SIZE, SQRT, ACOSH, ACOS, ASINH, ASIN, ATANH, ATAN, COSH, COS, SINH, SIN, TANH, TAN, ABS, BERNOULLI, BETA, BINOMIAL, CONSTANT, ERLANG, EXPONENTIAL, GAMMA, GEOMETRIC, LOG_NORMAL, NORMAL, POISSON, RANDOM, TRIANGLE, UNIFORM, WEIBULL, FORMAT, SCALE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StdLibFunction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StdLibFunction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StdLibFunction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StdLibFunction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StdLibFunction get(int value) {
        switch (value) {
            case 1: {
                return MINIMUM;
            }
            case 2: {
                return MAXIMUM;
            }
            case 3: {
                return POWER;
            }
            case 4: {
                return SIGN;
            }
            case 5: {
                return CBRT;
            }
            case 6: {
                return CEIL;
            }
            case 7: {
                return DELETE;
            }
            case 8: {
                return EMPTY;
            }
            case 9: {
                return EXP;
            }
            case 10: {
                return FLOOR;
            }
            case 15: {
                return LN;
            }
            case 16: {
                return LOG;
            }
            case 17: {
                return POP;
            }
            case 19: {
                return ROUND;
            }
            case 13: {
                return SIZE;
            }
            case 22: {
                return SQRT;
            }
            case 23: {
                return ACOSH;
            }
            case 24: {
                return ACOS;
            }
            case 25: {
                return ASINH;
            }
            case 26: {
                return ASIN;
            }
            case 27: {
                return ATANH;
            }
            case 28: {
                return ATAN;
            }
            case 29: {
                return COSH;
            }
            case 30: {
                return COS;
            }
            case 31: {
                return SINH;
            }
            case 32: {
                return SIN;
            }
            case 33: {
                return TANH;
            }
            case 34: {
                return TAN;
            }
            case 0: {
                return ABS;
            }
            case 35: {
                return BERNOULLI;
            }
            case 36: {
                return BETA;
            }
            case 37: {
                return BINOMIAL;
            }
            case 38: {
                return CONSTANT;
            }
            case 39: {
                return ERLANG;
            }
            case 40: {
                return EXPONENTIAL;
            }
            case 41: {
                return GAMMA;
            }
            case 42: {
                return GEOMETRIC;
            }
            case 43: {
                return LOG_NORMAL;
            }
            case 44: {
                return NORMAL;
            }
            case 45: {
                return POISSON;
            }
            case 46: {
                return RANDOM;
            }
            case 47: {
                return TRIANGLE;
            }
            case 48: {
                return UNIFORM;
            }
            case 49: {
                return WEIBULL;
            }
            case 11: {
                return FORMAT;
            }
            case 12: {
                return SCALE;
            }
        }
        return null;
    }

    private StdLibFunction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

