/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver.stats;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.engine.optimizer.StatsMatcher;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemWriter;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.tdb2.solver.stats.StatsCollector;
import org.apache.jena.tdb2.solver.stats.StatsResults;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Stats {
    static Item ZERO = Item.createNode(NodeFactoryExtra.intToNode(0));

    public static void write(String filename, StatsResults stats) {
        Stats.write(filename, stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    public static void write(OutputStream output, StatsResults stats) {
        Stats.write(output, stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    private static void write(String filename, Map<Node, Long> predicateStats, Map<Node, Long> typeStats, long statsTotal) {
        try (BufferedOutputStream statsOut = new BufferedOutputStream(new FileOutputStream(filename));){
            Stats.write(statsOut, predicateStats, typeStats, statsTotal);
        }
        catch (IOException ex) {
            Log.warn(Stats.class, "Problem when writing stats file", ex);
        }
    }

    private static void write(OutputStream output, Map<Node, Long> predicateStats, Map<Node, Long> typeStats, long statsTotal) {
        Item item = Stats.format(predicateStats, typeStats, statsTotal);
        ItemWriter.write(output, item);
    }

    public static StatsCollector gather(Graph graph) {
        StatsCollector stats = new StatsCollector();
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            stats.record((Object)null, t.getSubject(), t.getPredicate(), t.getObject());
        }
        return stats;
    }

    public static Item format(StatsResults stats) {
        return Stats.format(stats.getPredicates(), stats.getTypes(), stats.getCount());
    }

    private static Item format(Map<Node, Long> predicates, Map<Node, Long> types, long count) {
        Item stats = Item.createList();
        ItemList statsList = stats.getList();
        statsList.add("stats");
        Item meta = Item.createTagged("meta");
        Item.addPair(meta.getList(), "timestamp", NodeFactoryExtra.nowAsDateTime());
        Item.addPair(meta.getList(), "run@", DateTimeUtils.nowAsString());
        if (count >= 0L) {
            Item.addPair(meta.getList(), "count", NodeFactoryExtra.intToNode(count));
        }
        statsList.add(meta);
        for (Map.Entry<Node, Long> entry : types.entrySet()) {
            Node type = entry.getKey();
            Stats.addTypeTriple(statsList, type, NodeFactoryExtra.intToNode(entry.getValue()));
        }
        for (Map.Entry<Node, Long> entry : predicates.entrySet()) {
            Node node = entry.getKey();
            if (node.getURI().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            Item.addPair(statsList, node, NodeFactoryExtra.intToNode(entry.getValue()));
        }
        Item.addPair(statsList, StatsMatcher.OTHER, ZERO);
        return stats;
    }

    private static void addTypeTriple(ItemList statsList, Node type, Node intCount) {
        ItemList triple = new ItemList();
        triple.add("VAR");
        triple.add(NodeConst.nodeRDFType);
        triple.add(type);
        Item.addPair(statsList, Item.createList(triple), Item.createNode(intCount));
    }
}

