/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeUtils;

public class splitIRI
extends PropertyFunctionEval {
    public splitIRI() {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_LIST);
    }

    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argSubject.isList()) {
            throw new QueryBuildException(Lib.className(this) + "Subject must be a single node or variable, not a list");
        }
        if (!argObject.isList()) {
            throw new QueryBuildException(Lib.className(this) + "Object must be a list of two elements");
        }
        if (argObject.getArgList().size() != 2) {
            throw new QueryBuildException(Lib.className(this) + "Object is a list but it has " + argObject.getArgList().size() + " elements - should be 2");
        }
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        try {
            if (argSubject.getArg().isLiteral() || argSubject.getArg().isBlank()) {
                return IterLib.noResults(execCxt);
            }
            if (argSubject.getArg().isURI()) {
                return this.subjectIsIRI(argSubject.getArg(), argObject, binding, execCxt);
            }
            return this.subjectIsVariable(argSubject.getArg(), argObject, execCxt);
        }
        catch (QueryException ex) {
            Log.warn(this, "Unexpected problems in splitIRI: " + ex.getMessage());
            return null;
        }
    }

    private QueryIterator subjectIsIRI(Node subject, PropFuncArg argObject, Binding binding, ExecutionContext execCxt) {
        String namespace2 = subject.getNameSpace();
        String localname2 = subject.getLocalName();
        Node namespaceNode = argObject.getArg(0);
        Node localnameNode = argObject.getArg(1);
        BindingBuilder builder = null;
        if (Var.isVar(namespaceNode) || Var.isVar(localnameNode)) {
            builder = Binding.builder(binding);
        }
        if (Var.isVar(namespaceNode)) {
            builder.add(Var.alloc(namespaceNode), NodeFactory.createURI(namespace2));
            if (localnameNode.isVariable() && Objects.equals(namespaceNode, localnameNode)) {
                localnameNode = NodeFactory.createURI(namespace2);
            }
        } else {
            String ns = null;
            if (namespaceNode.isURI()) {
                ns = namespaceNode.getURI();
            }
            if (namespaceNode.isLiteral()) {
                ns = NodeUtils.stringLiteral(namespaceNode);
            }
            if (ns == null || !ns.equals(namespace2)) {
                return IterLib.noResults(execCxt);
            }
        }
        if (Var.isVar(localnameNode)) {
            builder.add(Var.alloc(localnameNode), NodeFactory.createLiteralString(localname2));
        } else {
            String lc = NodeUtils.stringLiteral(localnameNode);
            if (lc == null || !lc.equals(localname2)) {
                return IterLib.noResults(execCxt);
            }
        }
        Binding b2 = builder == null ? binding : builder.build();
        return IterLib.result(b2, execCxt);
    }

    private QueryIterator subjectIsVariable(Node arg, PropFuncArg argObject, ExecutionContext execCxt) {
        Log.warn(this, "Subject to property function splitURI is not a bound nor a constant.");
        return IterLib.noResults(execCxt);
    }
}

