/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.parser;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shex.ShapeMap;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.ShexRecord;

public class ShExJ {
    public static ShapeMap readShapeMapJson(InputStream input) {
        JsonValue x;
        if (input instanceof BufferedInputStream) {
            input = new BufferedInputStream(input, 131072);
        }
        if (!(x = JSON.parseAny(input)).isArray()) {
            throw new ShexException("Shex shape map: not a JSON array");
        }
        ArrayList<ShexRecord> associations = new ArrayList<ShexRecord>();
        x.getAsArray().forEach(j -> {
            if (!j.isObject()) {
                // empty if block
            }
            ShexRecord a = ShExJ.parseShapeMapEntry(j.getAsObject());
            associations.add(a);
        });
        return ShapeMap.create(associations);
    }

    private static ShexRecord parseShapeMapEntry(JsonObject obj) {
        try {
            String uri = ShExJ.getStrOrNull(obj, "node");
            if (uri == null) {
                throw new ShexException("Missing: required field: \"node\"");
            }
            String shapeURI = ShExJ.getStrOrNull(obj, "shape");
            if (shapeURI == null) {
                throw new ShexException("Missing: required field: \"shape\"");
            }
            Node nodeFocus = NodeFactory.createURI(uri);
            Node nodeShape = NodeFactory.createURI(shapeURI);
            return new ShexRecord(nodeFocus, nodeShape);
        }
        catch (JsonException ex) {
            throw new ShexException("Failed to parse shape map entry: " + JSON.toStringFlat(obj));
        }
    }

    private static String getStrOrNull(JsonObject obj, String field) {
        JsonValue jv = obj.get(field);
        if (jv == null) {
            return null;
        }
        if (jv.isString()) {
            return jv.getAsString().value();
        }
        return null;
    }
}

