/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.implicitobjects;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public static String packagePath = URLClientIT.class.getPackageName().replace(".", "/");

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/core_syntax/implicitobjects");
        this.setContextRoot("/jsp_coresyntx_implicitobjects_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_coresyntx_implicitobjects_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_coresyntx_implicitobjects_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/Errorpage.jsp")), "Errorpage.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkSession.jsp")), "checkSession.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkResponse.jsp")), "checkResponse.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkRequest.jsp")), "checkRequest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkPageContext.jsp")), "checkPageContext.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkPage.jsp")), "checkPage.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkOut.jsp")), "checkOut.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkException.jsp")), "checkException.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkConfig.jsp")), "checkConfig.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/checkApplication.jsp")), "checkApplication.jsp");
        return archive;
    }

    @Test
    public void checkSessionTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkSession.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkSession");
        this.invoke();
    }

    @Test
    public void checkConfigTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkConfig.gf");
        this.setGoldenFileStream(gfStream);
        String testName = "checkConfig";
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("goldenfile", testName + ".gf");
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_implicitobjects_web/" + testName + " HTTP/1.0");
        this.invoke();
    }

    @Test
    public void checkExceptionTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkException.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkException");
        TEST_PROPS.setProperty("ignore_status_code", "true");
        this.invoke();
    }

    @Test
    public void checkOutTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkOut.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkOut");
        this.invoke();
    }

    @Test
    public void checkPageTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkPage.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkPage");
        this.invoke();
    }

    @Test
    public void checkPageContextTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkPageContext.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkPageContext");
        this.invoke();
    }

    @Test
    public void checkRequestTest() throws Exception {
        String testName = "checkRequest";
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkRequest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("testname", testName + "Test");
        TEST_PROPS.setProperty("goldenfile", testName + ".gf");
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_implicitobjects_web/" + testName + ".jsp?Years=2 HTTP/1.0");
        this.invoke();
    }

    @Test
    public void checkResponseTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkResponse.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkResponse");
        TEST_PROPS.setProperty("expected_headers", "TestHeader:Method call OK");
        this.invoke();
    }

    @Test
    public void checkApplicationTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/checkApplication.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "checkApplication");
        this.invoke();
    }
}

