/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.mdcomplete;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.SimplePrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import javax.resource.spi.work.SecurityContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;

public class TSNestedSecurityContext
extends SecurityContext {
    private String userName;
    private String password;
    private String eisPrincipalName;
    private boolean translationRequired;
    private Subject subject;
    private String description;
    private String sicName;
    protected boolean expectPVCSuccess = true;
    private boolean useCPC = true;
    private boolean useGPC = true;
    private boolean usePVC = true;

    public TSNestedSecurityContext(String userName, String password, String eisPrincipalName, boolean translationRequired) {
        this(userName, password, eisPrincipalName, translationRequired, true);
    }

    public TSNestedSecurityContext(String userName, String password, String eisPrincipalName, boolean translationRequired, boolean expectSuccess) {
        this.userName = userName;
        this.password = password;
        this.eisPrincipalName = eisPrincipalName;
        this.translationRequired = translationRequired;
        this.sicName = super.getName();
        this.description = super.getDescription();
        this.expectPVCSuccess = expectSuccess;
    }

    public void setCallbacks(boolean bCPC, boolean bGPC, boolean bPVC) {
        this.useCPC = bCPC;
        this.useGPC = bGPC;
        this.usePVC = bPVC;
    }

    public void setUserName(String val) {
        this.userName = val;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String val) {
        this.sicName = val;
    }

    public String getName() {
        return this.sicName;
    }

    public void setUseCPC(boolean val) {
        this.useCPC = val;
    }

    public boolean getUseCPC() {
        return this.useCPC;
    }

    public void setUseGPC(boolean val) {
        this.useGPC = val;
    }

    public boolean getUseGPC() {
        return this.useGPC;
    }

    public void setUsePVC(boolean val) {
        this.usePVC = val;
    }

    public boolean getUsePVC() {
        return this.usePVC;
    }

    public boolean isTranslationRequired() {
        return this.translationRequired;
    }

    public void doCallbackVerification(CallbackHandler callbackHandler, Subject execSubject, Subject serviceSubject, Principal principal) {
        ArrayList<Object> callbacks = new ArrayList<Object>();
        this.debug("in doCallbackVerification()  translationRequired=" + this.translationRequired + " expectPVCSuccess=" + this.expectPVCSuccess);
        GroupPrincipalCallback gpc = null;
        String[] gpcGroups = new String[]{"phakegrp1", "phakegrp2"};
        if (this.useGPC) {
            this.debug("doCallbackVerification():  initializing PVC");
            gpc = new GroupPrincipalCallback(execSubject, gpcGroups);
            this.debug("GPC with groups={phakegrp1, phakegrp2} ");
            callbacks.add(gpc);
        }
        PasswordValidationCallback pvc = null;
        if (this.usePVC && !this.translationRequired) {
            this.debug("doCallbackVerification():  initializing PVC");
            char[] pwd = null;
            if (this.password != null) {
                pwd = this.password.toCharArray();
            }
            if (this.userName != null) {
                pvc = new PasswordValidationCallback(execSubject, this.userName, pwd);
                this.debug("setting PVC with user [ " + this.userName + " ] + password [ " + this.password + " ]");
            } else {
                pvc = new PasswordValidationCallback(execSubject, null, pwd);
                this.debug("setting PVC with user=null  + password [ " + this.password + " ]");
            }
            callbacks.add(pvc);
        }
        CallerPrincipalCallback cpc = null;
        if (this.usePVC || this.useCPC) {
            execSubject.getPrincipals().add((Principal)new SimplePrincipal(this.userName, this.password));
            this.debug("setting CPC with userName : " + this.userName + "   pwd = " + this.password);
            cpc = new CallerPrincipalCallback(execSubject, this.userName);
            callbacks.add(cpc);
        }
        Callback[] callbackArray = new Callback[callbacks.size()];
        try {
            callbackHandler.handle(callbacks.toArray(callbackArray));
            String sval = "setupSecurityContext callbackhandler supports required callback types.";
            this.debug(sval);
            if (pvc != null && !pvc.getResult()) {
                sval = "Password validation callback failure for userName = " + this.userName;
                this.debug(sval);
                if (this.expectPVCSuccess) {
                    String str = "ERROR: got unexpected PVC failed for user " + this.userName;
                    this.debug(str);
                    throw new Error(str);
                }
                String str = "TSNestedSecurityContext expected PVC failure and got it.";
                ConnectorStatus.getConnectorStatus().logState(str);
                this.debug(str);
            } else if (pvc == null) {
                this.debug("ERROR :  pvc = null but should have be non-null");
                this.debug("usePVC = " + this.usePVC);
            } else {
                this.debug("ERROR :  pvc.getResult()=" + pvc.getResult());
                this.debug("usePVC = " + this.usePVC);
            }
        }
        catch (UnsupportedCallbackException e) {
            String sval = "setupSecurityContext() callbackhandler does not support a required callback type!";
            this.debug("doCallbackVerification():  " + sval);
            this.debug("UnsupportedCallbackException message is : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.debug("doCallbackVerification():  exception occured : " + e.getMessage());
        }
    }

    public void setupSecurityContext(CallbackHandler callbackHandler, Subject execSubject, Subject serviceSubject) {
        this.validateCallbackHandler(callbackHandler);
        this.validateExecSubject(execSubject);
        this.validateServiceSubject(serviceSubject);
        SimplePrincipal principal = null;
        if (this.translationRequired && this.eisPrincipalName != null) {
            principal = new SimplePrincipal(this.eisPrincipalName);
            this.debug("setupSecurityContext():  translationRequired && (eisPrincipalName != null)");
        } else if (!this.translationRequired && this.userName != null) {
            principal = new SimplePrincipal(this.userName);
            this.debug("setupSecurityContext():  !translationRequired && (userName != null)");
        }
        if (callbackHandler != null) {
            String str = "setupSecurityContext() called with non-null callbackHandler";
            this.debug(str);
            this.doCallbackVerification(callbackHandler, execSubject, serviceSubject, (Principal)principal);
        } else {
            this.debug("setupSecurityContext() called with invalid (null) callbackHandler");
        }
    }

    private void validateCallbackHandler(CallbackHandler callbackHandler) {
        if (callbackHandler != null) {
            String str = "setupSecurityContext() called with non-null callbackHandler";
            this.debug(str);
        } else {
            String str = "setupSecurityContext() called with invalid (null) callbackHandler";
            this.debug(str);
        }
    }

    private void validateExecSubject(Subject execSubject) {
        if (execSubject != null && !execSubject.isReadOnly()) {
            String str = "setupSecurityContext() called with valid executionSubject";
            this.debug(str);
        } else {
            String str = "ERROR:  setupSecurityContext() called with invalid executionSubject";
            this.debug(str);
        }
    }

    private void validateServiceSubject(Subject serviceSubject) {
        if (serviceSubject != null && !serviceSubject.isReadOnly()) {
            String str = "setupSecurityContext() called with valid serviceSubject";
            this.debug(str);
        } else if (serviceSubject != null && serviceSubject.isReadOnly()) {
            String str = "setupSecurityContext() called with invalid executionSubject";
            this.debug(str);
        } else if (serviceSubject == null) {
            String str = "ERROR - setupSecurityContext() called with null serviceSubject.";
        } else {
            String str = "setupSecurityContext() called with valid serviceSubject";
            this.debug(str);
        }
    }

    public Subject getSubject() {
        if (this.translationRequired) {
            if (this.subject == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add((Principal)new SimplePrincipal(this.eisPrincipalName));
            }
            return this.subject;
        }
        return null;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer("{");
        toString.append("userName : " + this.userName);
        toString.append(", password : " + this.password);
        toString.append(", eisPrincipalName : " + this.eisPrincipalName);
        toString.append(", translationRequired : " + this.translationRequired);
        toString.append("}");
        return toString.toString();
    }

    public void debug(String message) {
        Debug.trace((String)(" in TSNestedSecurityContext: " + message));
    }
}

