/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.appclient.deploy.ejbref.casesens;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.appclient.deploy.ejbref.casesens.ReferencedBean;
import com.sun.ts.tests.appclient.deploy.ejbref.casesens.ReferencedBeanEJB;
import com.sun.ts.tests.assembly.util.shared.ejbref.common.ReferencedBeanCode;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.ejb.wrappers.StatelessWrapper;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="platform"), @Tag(value="tck-appclient")})
public class Client
extends EETest {
    private static final String prefix = "java:comp/env/ejb/";
    private static final String bean1Lookup = "java:comp/env/ejb/Philosopher";
    private static final String bean2Lookup = "java:comp/env/ejb/philosopher";
    private static final String bean1RefName = "Voltaire";
    private static final String bean2RefName = "Rousseau";
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="appclient_dep_ejbref_casesens")
    public static EnterpriseArchive createDeployment(@ArquillianResource TestArchiveProcessor archiveProcessor) throws IOException {
        JavaArchive ejbClient = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"appclient_dep_ejbref_casesens_client.jar");
        ejbClient.addPackages(true, new Package[]{Client.class.getPackage()});
        ejbClient.addPackages(true, new String[]{"com.sun.ts.lib.harness"});
        ejbClient.addClass(EETest.class);
        URL appClientUrl = Client.class.getResource("appclient_dep_ejbref_casesens_client.xml");
        ejbClient.addAsManifestResource(appClientUrl, "application-client.xml");
        URL sunAppClientUrl = Client.class.getResource("appclient_dep_ejbref_casesens_client.jar.sun-application-client.xml");
        ejbClient.addAsManifestResource(sunAppClientUrl, "sun-application-client.xml");
        ejbClient.addAsManifestResource((Asset)new StringAsset("Main-Class: " + Client.class.getName() + "\n"), "MANIFEST.MF");
        JavaArchive ejb = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"appclient_dep_ejbref_casesens_ejb.jar");
        ejb.addClasses(new Class[]{ReferencedBean.class, ReferencedBeanEJB.class, ReferencedBeanCode.class, StatelessWrapper.class});
        URL resURL = Client.class.getResource("appclient_dep_ejbref_casesens_ejb.jar.sun-ejb-jar.xml");
        ejb.addAsManifestResource(resURL, "sun-ejb-jar.xml");
        resURL = Client.class.getResource("appclient_dep_ejbref_casesens_ejb.xml");
        ejb.addAsManifestResource(resURL, "ejb-jar.xml");
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"appclient_dep_ejbref_casesens.ear");
        ear.addAsModule((Archive)ejbClient);
        ear.addAsModule((Archive)ejb);
        return ear;
    }

    public void setup(String[] args, Properties props) throws Exception {
        this.props = props;
        try {
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Setup succeed (got naming context).");
        }
        catch (Exception e) {
            throw new Exception("[Client] Setup failed:", e);
        }
    }

    @Test
    @TargetVehicle(value="appclient")
    public void testCaseSensitivity() throws Exception {
        ReferencedBean bean1 = null;
        ReferencedBean bean2 = null;
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"[Client] Looking up 'java:comp/env/ejb/Philosopher'...");
            bean1 = (ReferencedBean)this.nctx.lookup(bean1Lookup, ReferencedBean.class);
            bean1.createNamingContext();
            bean1.initLogging(this.props);
            String bean1Name = bean1.whoAreYou();
            TestUtil.logTrace((String)("java:comp/env/ejb/Philosophername is '" + bean1Name + "'"));
            TestUtil.logTrace((String)"[Client] Looking up 'java:comp/env/ejb/philosopher'...");
            bean2 = (ReferencedBean)this.nctx.lookup(bean2Lookup, ReferencedBean.class);
            bean2.createNamingContext();
            bean2.initLogging(this.props);
            String bean2Name = bean2.whoAreYou();
            TestUtil.logTrace((String)("java:comp/env/ejb/philosopher name is '" + bean2Name + "'"));
            boolean bl = pass = bean1Name.equals(bean1RefName) && bean2Name.equals(bean2RefName);
            if (!pass) {
                TestUtil.logErr((String)("[Client] java:comp/env/ejb/Philosophername is '" + bean1Name + "' expected 'Voltaire'"));
                TestUtil.logErr((String)("[Client] java:comp/env/ejb/philosophername is '" + bean2Name + "' expected 'Rousseau'"));
                throw new Exception("ejb-ref casesens test failed!");
            }
        }
        catch (Exception e) {
            throw new Exception("ejb-ref casesens test failed: " + e, e);
        }
    }

    public void cleanup() throws Exception {
        this.logMsg("[Client] cleanup()");
    }
}

