/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.equals;

import com.sun.ts.tests.ejb30.common.equals.Comparator;
import com.sun.ts.tests.ejb30.common.equals.LocalCartIF;
import com.sun.ts.tests.ejb30.common.equals.LocalShoppingCartIF;
import com.sun.ts.tests.ejb30.common.equals.TestBeanBase;
import com.sun.ts.tests.ejb30.common.equals.TestIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import javax.naming.NamingException;

@Stateless(name="test-bean-for-stateful")
@Remote
public class TestBeanForStateful
extends TestBeanBase
implements TestIF {
    @Resource(name="sessionContext")
    private SessionContext sessionContext;
    @EJB(name="cart")
    private LocalCartIF cart;
    @EJB(name="cartOther")
    private LocalCartIF cartOther;
    @EJB(name="shoppingCart")
    private LocalShoppingCartIF shoppingCart;
    @EJB(name="shoppingCartOther")
    private LocalShoppingCartIF shoppingCartOther;

    @Override
    protected SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public void remove() {
    }

    @Override
    public void selfEquals() throws TestFailedException {
        Comparator.compare(this.cart, this.cart, true, true);
        Comparator.compare(this.shoppingCart, this.shoppingCart, true, true);
    }

    @Override
    public void selfEqualsLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
            this.removeCart(cart);
            this.removeShoppingCart(shoppingCart);
            cart = this.getSessionContext().lookup("cart");
            shoppingCart = this.getSessionContext().lookup("shoppingCart");
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
            this.removeCart(cart);
            this.removeShoppingCart(shoppingCart);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void otherNotEquals() throws TestFailedException {
        Comparator.compare(this.cart, this.cartOther, false, true);
        Comparator.compare(this.shoppingCart, this.shoppingCartOther, false, true);
    }

    @Override
    public void otherNotEqualsLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cartOther = ServiceLocator.lookupByShortName("cartOther");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCartOther = ServiceLocator.lookupByShortName("shoppingCartOther");
            Comparator.compare(cart, cartOther, this.cart, false, true);
            Comparator.compare(shoppingCart, shoppingCartOther, this.shoppingCart, false, true);
            this.removeCart(cart);
            this.removeCart(cartOther);
            this.removeShoppingCart(shoppingCart);
            this.removeShoppingCart(shoppingCartOther);
            cart = this.getSessionContext().lookup("cart");
            cartOther = this.getSessionContext().lookup("cartOther");
            shoppingCart = this.getSessionContext().lookup("shoppingCart");
            shoppingCartOther = this.getSessionContext().lookup("shoppingCartOther");
            Comparator.compare(cart, cartOther, this.cart, false, true);
            Comparator.compare(shoppingCart, shoppingCartOther, this.shoppingCart, false, true);
            this.removeCart(cart);
            this.removeCart(cartOther);
            this.removeShoppingCart(shoppingCart);
            this.removeShoppingCart(shoppingCartOther);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void differentInterfaceNotEqual() throws TestFailedException {
        Comparator.compare(this.cart, this.shoppingCart, false, true);
    }

    @Override
    public void differentInterfaceNotEqualLookup() throws TestFailedException {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, shoppingCart, false, true);
            this.removeCart(cart);
            this.removeShoppingCart(shoppingCart);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public void otherEqualsLookup() throws TestFailedException {
        throw new TestFailedException("This method should not be invoked for this test.");
    }

    @Override
    public void otherEquals() throws TestFailedException {
        throw new TestFailedException("This method should not be invoked for this test.");
    }

    private void removeCart(Object aCart) {
        ((LocalCartIF)aCart).remove();
    }

    private void removeShoppingCart(Object aShoppingCart) {
        ((LocalShoppingCartIF)aShoppingCart).remove();
    }
}

