/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.servlet;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Properties;

public class ServletVehicle
extends HttpServlet {
    protected Properties properties = null;
    protected String[] arguments = null;
    protected EETest testObj = null;

    public void init(ServletConfig config) throws ServletException {
        TestUtil.logTrace("init " + ((Object)((Object)this)).getClass().getName() + " ...");
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            TestUtil.logTrace("ServletVehicle - In doGet");
            Class<?> hsClazz = ((Object)((Object)this)).getClass();
            TestUtil.logTrace("ServletVehicle - HttpServlet.class: " + String.valueOf(hsClazz.getClassLoader()));
            Class<?> clazz = req.getClass();
            TestUtil.logTrace("ServletVehicle - HttpServletRequest.class: " + String.valueOf(clazz.getClassLoader()));
            ServletInputStream is = req.getInputStream();
            ObjectInputStream objInStream = new ObjectInputStream(new BufferedInputStream((InputStream)is));
            System.out.println("ServletVehicle - got InputStream");
            TestUtil.logTrace("ServletVehicle - got InputStream");
            this.properties = (Properties)objInStream.readObject();
            System.out.println("read properties!!!");
            String testClassName = TestUtil.getProperty(this.properties, "test_classname");
            Class<?> c = Class.forName(testClassName);
            this.testObj = (EETest)c.newInstance();
            this.arguments = (String[])objInStream.readObject();
            TestUtil.logTrace("ServletVehicle - read Objects");
            try {
                TestUtil.init(this.properties);
                TestUtil.logTrace("Remote logging set for Servlet Vehicle");
                TestUtil.logTrace("ServletVehicle - Here are the props");
                TestUtil.list(this.properties);
            }
            catch (Exception e) {
                throw new ServletException("unable to initialize remote logging");
            }
            ObjectOutputStream objOutStream = new ObjectOutputStream((OutputStream)res.getOutputStream());
            System.out.println("got outputstream");
            RemoteStatus finalStatus = this.runTest();
            System.out.println("ran test");
            objOutStream.writeObject(finalStatus);
            objOutStream.flush();
            objOutStream.close();
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            TestUtil.logTrace(t.getMessage());
            t.printStackTrace();
            throw new ServletException("test failed to run within the Servlet Vehicle");
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        System.out.println("In doPost!");
        TestUtil.logTrace("In doPost");
        this.doGet(req, res);
    }

    protected RemoteStatus runTest() throws RemoteException {
        RemoteStatus sTestStatus = new RemoteStatus(Status.passed(""));
        try {
            sTestStatus = new RemoteStatus(this.testObj.run(this.arguments, this.properties));
            if (sTestStatus.getType() == 0) {
                TestUtil.logMsg("Test running in servlet vehicle passed");
            } else {
                TestUtil.logMsg("Test running in servlet vehicle failed");
            }
        }
        catch (Throwable e) {
            TestUtil.logErr("Test running in servlet vehicle failed", e);
            sTestStatus = new RemoteStatus(Status.failed("Test running in servlet vehicle failed"));
        }
        return sTestStatus;
    }
}

