/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.se.generators.sequencegenerators;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.se.generators.sequencegenerators.Simple;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    String schemaGenerationDir = null;
    String sTestCase = "jpa_jpa22_se_generators_sequencegenerators";
    boolean supportSequence;

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.supportSequence = Boolean.valueOf(System.getProperty("db.supports.sequence"));
            this.schemaGenerationDir = System.getProperty("user.dir");
            if (!this.schemaGenerationDir.endsWith(File.separator)) {
                this.schemaGenerationDir = this.schemaGenerationDir + File.separator;
            }
            this.schemaGenerationDir = this.schemaGenerationDir + "schemaGeneration";
            this.logMsg("schemaGenerationDir=" + this.schemaGenerationDir);
            File f = new File(this.schemaGenerationDir);
            this.logMsg("Delete existing directory ");
            this.deleteItem(f);
            this.logMsg("Create new directory ");
            if (!f.mkdir()) {
                String msg = "Could not mkdir:" + f.getAbsolutePath();
                throw new Exception(msg);
            }
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void sequenceGeneratorTest() throws Exception {
        if (!this.supportSequence) {
            this.logMsg("WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            return;
        }
        boolean pass1a = false;
        boolean pass1b = false;
        boolean pass2a = false;
        boolean pass2b = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Create the script(s)");
        String CREATEFILENAME = this.schemaGenerationDir + File.separator + "create_" + this.sTestCase + ".sql";
        String DROPFILENAME = this.schemaGenerationDir + File.separator + "drop_" + this.sTestCase + ".sql";
        File f1 = new File(CREATEFILENAME);
        this.logTrace("Deleting previous create script");
        this.deleteItem(f1);
        File f2 = new File(DROPFILENAME);
        this.logTrace("Deleting previous drop script");
        this.deleteItem(f2);
        Properties props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "none");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "false");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", this.convertToURI(CREATEFILENAME));
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        this.logMsg("Executing Persistence.createEntityManagerFactory(...)");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)props);
        emf.close();
        emf = null;
        this.logMsg("Check script(s) content");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("CREATE TABLE SCHEMAGENSIMPLE");
        expected.add("ID");
        expected.add("PRIMARY KEY (ID)");
        pass1a = this.findDataInFile(f1, expected);
        pass1b = this.findDataInFile(f1, "CREATE SEQUENCE SEQGENERATOR START WITH 10");
        expected.clear();
        expected.add("DROP TABLE");
        expected.add("SCHEMAGENSIMPLE");
        pass2a = this.findDataInFile(f2, expected);
        expected.clear();
        expected.add("DROP SEQUENCE");
        expected.add("SEQGENERATOR");
        pass2b = this.findDataInFile(f2, expected);
        this.logTrace("Execute the create script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.create-database-schemas", "true");
        props.put("jakarta.persistence.schema-generation.create-script-source", this.convertToURI(CREATEFILENAME));
        this.displayProperties(props);
        this.logMsg("Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        try {
            this.logMsg("Persist some data");
            this.getEntityTransaction(true).begin();
            Simple s = new Simple();
            this.getEntityManager().persist((Object)s);
            this.getEntityTransaction().commit();
            this.clearCache();
            Simple s2 = (Simple)this.getEntityManager().find(Simple.class, (Object)s.getId());
            if (s2 == null) {
                this.logTrace("Received unexpected null from getEntityManager().find(Simple.class, 10)");
            } else if (s.equals(s2)) {
                this.logTrace("Received expected result:" + s.toString());
                pass3 = true;
            } else {
                this.logErr("Expected:" + s.toString());
                this.logErr("Actual:" + s2.toString());
            }
        }
        catch (Throwable t) {
            this.logErr("Received unexpected exception", t);
        }
        this.clearEMAndEMF();
        this.logTrace("Execute the drop script");
        props = this.getPersistenceUnitProperties();
        props.put("jakarta.persistence.schema-generation.database.action", "drop");
        props.put("jakarta.persistence.schema-generation.scripts.action", "none");
        props.put("jakarta.persistence.schema-generation.drop-script-source", this.convertToURI(DROPFILENAME));
        this.displayProperties(props);
        this.logMsg("Executing Persistence.generateSchema(...)");
        Persistence.generateSchema((String)this.getPersistenceUnitName(), (Map)props);
        this.clearEMAndEMF();
        this.logMsg("Try to persist an entity, it should fail");
        try {
            this.getEntityTransaction(true).begin();
            Simple s3 = new Simple(2);
            this.getEntityManager().persist((Object)s3);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.logErr("An exception should have been thrown if drop had occurred successfully");
        }
        catch (Exception ex) {
            this.logTrace("Receive expected exception");
            pass4 = true;
        }
        this.logTrace("pass1a:" + pass1a);
        this.logTrace("pass1b:" + pass1b);
        this.logTrace("pass2a:" + pass2a);
        this.logTrace("pass2b:" + pass2b);
        this.logTrace("pass3:" + pass3);
        this.logTrace("pass4:" + pass4);
        if (!(pass1a && pass1b && pass2a && pass2b && pass3 && pass4)) {
            throw new Exception("sequenceGeneratorTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Try to drop table SCHEMAGENSIMPLE");
            this.getEntityManager().createNativeQuery("DROP TABLE SCHEMAGENSIMPLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Throwable t) {
            this.logMsg("AN EXCEPTION WAS THROWN DURING DROP TABLE SCHEMAGENSIMPLE, IT MAY OR MAY NOT BE A PROBLEM, " + t.getMessage());
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
                this.clearEntityTransaction();
                this.clearEMAndEMF();
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

