/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.metamodel;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Employee;
import ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getMetamodel() throws Exception {
        boolean pass = false;
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = true;
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
        }
        if (!pass) {
            throw new Exception("getMetamodeltest failed");
        }
    }

    public void getEntities() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getEntities();
            if (orderSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                for (EntityType eType : orderSet) {
                    this.logTrace("entityType Name = " + eType.getName());
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEntities Test  failed");
        }
    }

    public void getManagedTypes() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set orderSet = metaModel.getManagedTypes();
            if (orderSet != null) {
                this.logTrace("Obtained Non-null Set of ManagedType");
                for (ManagedType mType : orderSet) {
                    Set attribSet = mType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        this.logTrace("attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getManagedTypes Test  failed");
        }
    }

    public void getEmbeddables() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set addrSet = metaModel.getEmbeddables();
            if (addrSet != null) {
                this.logTrace("Obtained Non-null Set of EmbeddableType");
                for (EmbeddableType eType : addrSet) {
                    Set attribSet = eType.getDeclaredAttributes();
                    if (attribSet == null) continue;
                    for (Attribute attrib : attribSet) {
                        this.logTrace("attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEmbeddables Test  failed");
        }
    }

    public void managedType() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            Set attribSet;
            String cActual;
            this.logMsg("Test entity");
            String expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Order";
            ManagedType mType = metaModel.managedType(Order.class);
            if (mType != null) {
                ManagedType mTypeOrder = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                        }
                        pass1 = true;
                    } else {
                        this.logErr("getDeclaredAttributes() returned null");
                    }
                } else {
                    this.logErr("Expected:" + expected + ", actual:" + cActual);
                }
            }
            this.logMsg("Test embeddable");
            expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Address";
            mType = metaModel.managedType(Address.class);
            if (mType != null) {
                ManagedType mTypeAddress = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeAddress.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                        }
                        pass2 = true;
                    } else {
                        this.logErr("getDeclaredAttributes() returned null");
                    }
                } else {
                    this.logErr("Expected:" + expected + ", actual:" + cActual);
                }
            }
            this.logMsg("Test superclass");
            expected = "ee.jakarta.tck.persistence.core.metamodelapi.metamodel.Employee";
            mType = metaModel.managedType(Employee.class);
            if (mType != null) {
                ManagedType mTypeEmployee = mType;
                cActual = mType.getJavaType().getName();
                if (cActual.equals(expected)) {
                    attribSet = mTypeEmployee.getDeclaredAttributes();
                    if (attribSet != null) {
                        for (Attribute attrib : attribSet) {
                            this.logTrace("attribute Name = " + attrib.getName());
                        }
                        pass3 = true;
                    } else {
                        this.logErr("getDeclaredAttributes() returned null");
                    }
                } else {
                    this.logErr("Expected:" + expected + ", actual:" + cActual);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("managedType Test failed");
        }
    }

    public void managedTypeIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            try {
                metaModel.managedType(Client.class);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("managedTypeIllegalArgumentException failed");
        }
    }

    public void entity() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eTypeOrder = metaModel.entity(Order.class);
            if (eTypeOrder != null) {
                this.logTrace("Obtained Non-null EntityType");
                Set attribSet = eTypeOrder.getDeclaredAttributes();
                if (attribSet != null) {
                    for (Attribute attrib : attribSet) {
                        this.logTrace("attribute Name = " + attrib.getName());
                    }
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("entity Test  failed");
        }
    }

    public void entityIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            try {
                metaModel.entity(Client.class);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("entityIllegalArgumentException  failed");
        }
    }

    public void embeddable() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("zipcode");
        expected.add("street");
        expected.add("state");
        expected.add("city");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                this.logTrace("Obtained Non-null Metamodel from EntityManager");
                EmbeddableType eTypeOrder = metaModel.embeddable(Address.class);
                if (eTypeOrder != null) {
                    this.logTrace("Obtained Non-null EmbeddableType");
                    Set attribSet = eTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            this.logErr("Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            String name = attrib.getName();
                            if (expected.contains(name)) {
                                this.logTrace("received attribute Name = " + name);
                                continue;
                            }
                            this.logErr("Received unexpected result" + name);
                            pass = false;
                        }
                    } else {
                        pass = false;
                        this.logErr("getDeclaredAttributes() returned null");
                    }
                } else {
                    pass = false;
                    this.logErr("embeddable() returned null");
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unxpected exception", e);
        }
    }

    public void embeddableIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                try {
                    metaModel.embeddable(Client.class);
                    this.logErr("Did not throw IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    this.logTrace("Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    this.logErr("Received unexpected exception", e);
                }
            } else {
                pass = false;
                this.logErr("getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("embeddableIllegalArgumentException failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

