/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_synchrec;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class MDBClient
extends EETest {
    private TSNamingContextInterface context = null;
    private Properties props = null;
    private Queue mdbRcvrQueue;
    private Queue rcvrQueue;
    private QueueConnection qConnect;
    private Queue cmtQ;
    private QueueSession session;
    private QueueConnectionFactory qFactory;
    private QueueSender qSender;
    private String jmsUser = null;
    private String jmsPassword = null;
    private TextMessage msg = null;
    long timeout;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        this.jmsUser = p.getProperty("user");
        this.jmsPassword = p.getProperty("password");
        try {
            this.timeout = Integer.parseInt(p.getProperty("jms_timeout"));
            TestUtil.logTrace((String)"in client setup");
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)"Client: Do lookups!");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.cmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.mdbRcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MY_QUEUE");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.session = this.qConnect.createQueueSession(false, 1);
            this.qConnect.start();
            this.cleanTheQueue(this.rcvrQueue);
            this.cleanTheQueue(this.mdbRcvrQueue);
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    public void test1() throws Exception {
        String TestCase = "syncRecTest1";
        int TestNum = 1;
        String mdbMessage = "my mdb message";
        try {
            this.createTestMessage(TestCase, TestNum);
            this.qSender = this.session.createSender(this.mdbRcvrQueue);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.msg.setStringProperty("TestCase", mdbMessage);
            this.qSender.send((Message)this.msg);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
            this.qSender = this.session.createSender(this.cmtQ);
            this.qSender.send((Message)this.msg);
            TestCase = "mdbResponse";
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("syncRecTest1 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            this.msg = null;
            if (this.qConnect != null) {
                this.qConnect.close();
            }
            this.logMsg("End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void createTestMessage(String TestCase, int num) {
        String myMessage = "MDB synchronous receive test";
        try {
            this.msg = this.session.createTextMessage();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Error setting user and password in jms msg");
        }
    }

    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            TestUtil.logTrace((String)"@checkOnResponse");
            for (int i = 0; i < 10 && !(status = this.getMessage(this.session, prop)); ++i) {
            }
            TestUtil.logTrace((String)"Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    private boolean getMessage(QueueSession session, String prop) throws Exception {
        try {
            TestUtil.logTrace((String)"top of getMessage");
            boolean gotit = false;
            String selector = "TestCase = 'mdbResponse'";
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue, selector);
            Message msgRec = null;
            msgRec = rcvr.receive(this.timeout);
            if (msgRec == null) {
                TestUtil.logTrace((String)"No message to receive!!!");
            } else {
                TestUtil.logTrace((String)"Success: getMessage received a msg!!!");
                gotit = this.recvMessageInternal(msgRec, prop);
            }
            return gotit;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"exception: ", (Throwable)e);
            throw new Exception("getMessage threw an exception!");
        }
    }

    private boolean recvMessageInternal(Message msgRec, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"@recvMessageInternal");
        if (msgRec != null) {
            TestUtil.logTrace((String)("Msg: " + msgRec.toString()));
            TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
            TestUtil.logTrace((String)("Status: " + msgRec.getStringProperty("Status")));
            TestUtil.logTrace((String)"=================================================");
            TestUtil.logTrace((String)("Msg: " + msgRec.toString()));
            if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logTrace((String)"Fail: Error(s) occurred! ");
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                TestUtil.logTrace((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
            }
        } else if (msgRec == null) {
            TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    private void cleanTheQueue(Queue q) {
        try {
            TestUtil.logTrace((String)"Check if any messages left in queue");
            QueueReceiver qR = this.session.createReceiver(q);
            Message msg = qR.receive(this.timeout);
            while (msg != null) {
                TestUtil.logTrace((String)"Cleaned up a message in QUEUE!");
                msg = qR.receive(this.timeout);
            }
            qR.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logTrace((String)"Error in cleanTheQueue");
        }
    }
}

