/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.enventry.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.lite.NumberEnum;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.SessionContext;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.NamingException;

public abstract class EnvEntryBeanBase {
    @Resource
    private SessionContext sctx;
    private StringBuilder postConstructRecords = new StringBuilder();
    protected String myString;
    protected String compSameName;
    protected String moduleSameName;
    protected String appSameName;
    protected boolean myBoolean;
    protected byte myByte;
    protected short myShort;
    protected int myInt;
    protected long myLong;
    protected float myFloat;
    protected double myDouble;
    protected char myChar;
    protected TimeUnit timeUnit;
    protected NumberEnum numberEnum;
    protected Class<Helper> helperClass;
    protected Class<NumberEnum> numberEnumClass;
    protected Class<?> envEntryBeanBaseClass;
    protected Class testUtilClass;
    private String defaultString = "defaultString";
    private boolean defaultBoolean = false;
    private byte defaultByte = 0;
    private short defaultShort = 0;
    private int defaultInt = 0;
    private long defaultLong = 0L;
    private float defaultFloat = 0.0f;
    private double defaultDouble = 0.0;
    private char defaultChar = '\u0000';
    private NumberEnum defaultNumberEnum = NumberEnum.ONE;
    private Class defaultHelperClass = Helper.class;
    private String xmlString;
    private boolean xmlBoolean;
    private byte xmlByte;
    private short xmlShort;
    private int xmlInt;
    private long xmlLong;
    private float xmlFloat;
    private double xmlDouble;
    private char xmlChar;
    private NumberEnum xmlNumberEnum;
    private Class xmlHelperClass;

    @PostConstruct
    private void postConstruct() {
        this.verifyAnnotatedInjections();
        this.verifyDefaultValueInjections();
        this.verifyDescriptorInjections();
    }

    private void verifyAnnotatedInjections() {
        String s = "Verify injected fields:";
        Helper.assertEquals(s, "myString", this.myString, this.postConstructRecords);
        Helper.assertEquals(s, "compSameName2", this.compSameName, this.postConstructRecords);
        Helper.assertEquals(s, "moduleSameName", this.moduleSameName, this.postConstructRecords);
        Helper.assertEquals(s, "appSameName", this.appSameName, this.postConstructRecords);
        Helper.assertEquals(s, true, this.myBoolean, this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, this.myByte, this.postConstructRecords);
        Helper.assertEquals(s, (short)1, this.myShort, this.postConstructRecords);
        Helper.assertEquals(s, 1, this.myInt, this.postConstructRecords);
        Helper.assertEquals(s, 1L, this.myLong, this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), Float.valueOf(this.myFloat), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, this.myDouble, this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), Character.valueOf(this.myChar), this.postConstructRecords);
        Helper.assertEquals(s, (Object)TimeUnit.NANOSECONDS, (Object)this.timeUnit, this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, this.numberEnum, this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, this.helperClass, this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.class, this.numberEnumClass, this.postConstructRecords);
        Helper.assertEquals(s, EnvEntryBeanBase.class, this.envEntryBeanBaseClass, this.postConstructRecords);
        Helper.assertEquals(s, TestUtil.class, this.testUtilClass, this.postConstructRecords);
        s = "Verify injected fields with SessionContext lookup:";
        Helper.assertEquals(s, "myString", this.sctx.lookup(this.getLookupName("myString")), this.postConstructRecords);
        Helper.assertEquals(s, "compSameName2", this.sctx.lookup("java:comp/env/sameName2"), this.postConstructRecords);
        Helper.assertEquals(s, "moduleSameName", this.sctx.lookup("java:module/env/sameName"), this.postConstructRecords);
        Helper.assertEquals(s, "appSameName", this.sctx.lookup("java:app/env/sameName"), this.postConstructRecords);
        Helper.assertEquals(s, true, this.sctx.lookup(this.getLookupName("myBoolean")), this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, this.sctx.lookup(this.getLookupName("myByte")), this.postConstructRecords);
        Helper.assertEquals(s, (short)1, this.sctx.lookup(this.getLookupName("myShort")), this.postConstructRecords);
        Helper.assertEquals(s, 1, this.sctx.lookup(this.getLookupName("myInt")), this.postConstructRecords);
        Helper.assertEquals(s, 1L, this.sctx.lookup(this.getLookupName("myLong")), this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), this.sctx.lookup(this.getLookupName("myFloat")), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, this.sctx.lookup(this.getLookupName("myDouble")), this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), this.sctx.lookup(this.getLookupName("myChar")), this.postConstructRecords);
        Helper.assertEquals(s, (Object)TimeUnit.NANOSECONDS, this.sctx.lookup(this.getLookupName("timeUnit")), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, this.sctx.lookup(this.getLookupName("numberEnum")), this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, this.sctx.lookup(this.getLookupName("helperClass")), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.class, this.sctx.lookup(this.getLookupName("numberEnumClass")), this.postConstructRecords);
        Helper.assertEquals(s, EnvEntryBeanBase.class, this.sctx.lookup(this.getLookupName("envEntryBeanBaseClass")), this.postConstructRecords);
        Helper.assertEquals(s, TestUtil.class, this.sctx.lookup(this.getLookupName("testUtilClass")), this.postConstructRecords);
        s = "Verify injected fields with naming context lookup:";
        Helper.assertEquals(s, "myString", ServiceLocator.lookupNoTry(this.getLookupName("myString"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, "compSameName2", ServiceLocator.lookupNoTry("java:comp/env/sameName2", new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, "moduleSameName", ServiceLocator.lookupNoTry("java:module/env/sameName", new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, "appSameName", ServiceLocator.lookupNoTry("java:app/env/sameName", new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, true, ServiceLocator.lookupNoTry(this.getLookupName("myBoolean"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, ServiceLocator.lookupNoTry(this.getLookupName("myByte"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, (short)1, ServiceLocator.lookupNoTry(this.getLookupName("myShort"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1, ServiceLocator.lookupNoTry(this.getLookupName("myInt"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1L, ServiceLocator.lookupNoTry(this.getLookupName("myLong"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), ServiceLocator.lookupNoTry(this.getLookupName("myFloat"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, ServiceLocator.lookupNoTry(this.getLookupName("myDouble"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), ServiceLocator.lookupNoTry(this.getLookupName("myChar"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, (Object)TimeUnit.NANOSECONDS, ServiceLocator.lookupNoTry(this.getLookupName("timeUnit"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, ServiceLocator.lookupNoTry(this.getLookupName("numberEnum"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, ServiceLocator.lookupNoTry(this.getLookupName("helperClass"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.class, ServiceLocator.lookupNoTry(this.getLookupName("numberEnumClass"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, EnvEntryBeanBase.class, ServiceLocator.lookupNoTry(this.getLookupName("envEntryBeanBaseClass"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, TestUtil.class, ServiceLocator.lookupNoTry(this.getLookupName("testUtilClass"), new Context[0]), this.postConstructRecords);
    }

    private void verifyDefaultValueInjections() {
        String s = "Verify injections to fields that have default values:";
        Helper.assertEquals(s, "defaultString", this.defaultString, this.postConstructRecords);
        this.expectingNamingException("defaultString");
        Helper.assertEquals(s, false, this.defaultBoolean, this.postConstructRecords);
        this.expectingNamingException("defaultBoolean");
        Helper.assertEquals(s, (byte)0, this.defaultByte, this.postConstructRecords);
        this.expectingNamingException("defaultByte");
        Helper.assertEquals(s, (short)0, this.defaultShort, this.postConstructRecords);
        this.expectingNamingException("defaultShort");
        Helper.assertEquals(s, 0, this.defaultInt, this.postConstructRecords);
        this.expectingNamingException("defaultInt");
        Helper.assertEquals(s, 0L, this.defaultLong, this.postConstructRecords);
        this.expectingNamingException("defaultLong");
        Helper.assertEquals(s, Float.valueOf(0.0f), Float.valueOf(this.defaultFloat), this.postConstructRecords);
        this.expectingNamingException("defaultFloat");
        Helper.assertEquals(s, 0.0, this.defaultDouble, this.postConstructRecords);
        this.expectingNamingException("defaultDouble");
        Helper.assertEquals(s, Character.valueOf('\u0000'), Character.valueOf(this.defaultChar), this.postConstructRecords);
        this.expectingNamingException("defaultChar");
        Helper.assertEquals(s, NumberEnum.ONE, this.defaultNumberEnum, this.postConstructRecords);
        this.expectingNamingException("defaultNumberEnum");
        Helper.assertEquals(s, Helper.class, this.defaultHelperClass, this.postConstructRecords);
        this.expectingNamingException("defaultHelperClass");
    }

    private void verifyDescriptorInjections() {
        String s = "Verify injections with descriptor:";
        Helper.assertEquals(s, "xmlString", this.xmlString, this.postConstructRecords);
        Helper.assertEquals(s, true, this.xmlBoolean, this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, this.xmlByte, this.postConstructRecords);
        Helper.assertEquals(s, (short)1, this.xmlShort, this.postConstructRecords);
        Helper.assertEquals(s, 1, this.xmlInt, this.postConstructRecords);
        Helper.assertEquals(s, 1L, this.xmlLong, this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), Float.valueOf(this.xmlFloat), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, this.xmlDouble, this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), Character.valueOf(this.xmlChar), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, this.xmlNumberEnum, this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, this.xmlHelperClass, this.postConstructRecords);
        s = "Verify injected fields with SessionContext lookup:";
        Helper.assertEquals(s, "xmlString", this.sctx.lookup(this.getLookupName("xmlString")), this.postConstructRecords);
        Helper.assertEquals(s, true, this.sctx.lookup(this.getLookupName("xmlBoolean")), this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, this.sctx.lookup(this.getLookupName("xmlByte")), this.postConstructRecords);
        Helper.assertEquals(s, (short)1, this.sctx.lookup(this.getLookupName("xmlShort")), this.postConstructRecords);
        Helper.assertEquals(s, 1, this.sctx.lookup(this.getLookupName("xmlInt")), this.postConstructRecords);
        Helper.assertEquals(s, 1L, this.sctx.lookup(this.getLookupName("xmlLong")), this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), this.sctx.lookup(this.getLookupName("xmlFloat")), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, this.sctx.lookup(this.getLookupName("xmlDouble")), this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), this.sctx.lookup(this.getLookupName("xmlChar")), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, this.sctx.lookup(this.getLookupName("xmlNumberEnum")), this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, this.sctx.lookup(this.getLookupName("xmlHelperClass")), this.postConstructRecords);
        s = "Verify injected fields with naming context lookup:";
        Helper.assertEquals(s, "xmlString", ServiceLocator.lookupNoTry(this.getLookupName("xmlString"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, true, ServiceLocator.lookupNoTry(this.getLookupName("xmlBoolean"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, (byte)1, ServiceLocator.lookupNoTry(this.getLookupName("xmlByte"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, (short)1, ServiceLocator.lookupNoTry(this.getLookupName("xmlShort"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1, ServiceLocator.lookupNoTry(this.getLookupName("xmlInt"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1L, ServiceLocator.lookupNoTry(this.getLookupName("xmlLong"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Float.valueOf(1.0f), ServiceLocator.lookupNoTry(this.getLookupName("xmlFloat"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, 1.0, ServiceLocator.lookupNoTry(this.getLookupName("xmlDouble"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Character.valueOf('1'), ServiceLocator.lookupNoTry(this.getLookupName("xmlChar"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, NumberEnum.ONE, ServiceLocator.lookupNoTry(this.getLookupName("xmlNumberEnum"), new Context[0]), this.postConstructRecords);
        Helper.assertEquals(s, Helper.class, ServiceLocator.lookupNoTry(this.getLookupName("xmlHelperClass"), new Context[0]), this.postConstructRecords);
    }

    protected void expectingNamingException(String shortName) {
        try {
            Object obj = ServiceLocator.lookup(this.getLookupName(shortName), new Context[0]);
            throw new RuntimeException("Expecting NamingException, but got " + obj);
        }
        catch (NamingException e) {
            this.postConstructRecords.append("Got expected " + e);
            return;
        }
    }

    public String getLookupName(String s) {
        if (s == null) {
            return null;
        }
        return "java:comp/env/" + s;
    }

    public String getPostConstructRecords() {
        return this.postConstructRecords.toString();
    }
}

