/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.utils.Charsets;

public final class HttpDateFormat {
    private static final String ASCII_CHARSET_NAME = Charsets.ASCII_CHARSET.name();
    private static final int CACHE_SIZE = 1000;
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(GMT_ZONE_ID);
    private static final DateTimeFormatter[] FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(GMT_ZONE_ID), DateTimeFormatter.ofPattern("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US).withZone(GMT_ZONE_ID), DateTimeFormatter.ofPattern("EEE MMMM d HH:mm:ss yyyy", Locale.US).withZone(GMT_ZONE_ID)};
    private static volatile long nextGeneration;
    private static final AtomicBoolean isGeneratingNow;
    private static byte[] currentDateBytes;
    private static String cachedStringDate;
    private static volatile byte[] dateBytesForCachedStringDate;
    private static final ConcurrentMap<Long, String> formatCache;
    private static final ConcurrentMap<String, Long> parseCache;

    public static String getCurrentDate() {
        byte[] currentDateBytesNow = HttpDateFormat.getCurrentDateBytes();
        if (currentDateBytesNow != dateBytesForCachedStringDate) {
            try {
                cachedStringDate = new String(currentDateBytesNow, ASCII_CHARSET_NAME);
                dateBytesForCachedStringDate = currentDateBytesNow;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return cachedStringDate;
    }

    public static byte[] getCurrentDateBytes() {
        long now = System.currentTimeMillis();
        long diff = now - nextGeneration;
        if (diff < 0L || diff < 5000L && isGeneratingNow.get()) {
            return currentDateBytes;
        }
        while (!isGeneratingNow.compareAndSet(false, true)) {
            Thread.onSpinWait();
        }
        if (now > nextGeneration) {
            currentDateBytes = HttpCodecUtils.toCheckedByteArray(new StringBuilder(FORMATTER.format(Instant.ofEpochMilli(now))));
            nextGeneration = now + 1000L;
        }
        isGeneratingNow.set(false);
        return currentDateBytes;
    }

    public static String formatDate(long value, DateTimeFormatter formatter) {
        Long longValue = value = value / 1000L * 1000L;
        String cachedDate = (String)formatCache.get(longValue);
        if (cachedDate != null) {
            return cachedDate;
        }
        String newDate = Objects.requireNonNullElse(formatter, FORMATTER).format(Instant.ofEpochMilli(value));
        HttpDateFormat.updateFormatCache(longValue, newDate);
        return newDate;
    }

    public static long parseDate(String value, DateTimeFormatter[] formatters) {
        Long cachedDate = (Long)parseCache.get(value);
        if (cachedDate != null) {
            return cachedDate;
        }
        long date = HttpDateFormat.internalParseDate(value, Objects.requireNonNullElse(formatters, FORMATTERS));
        if (date != -1L) {
            HttpDateFormat.updateParseCache(value, date);
        }
        return date;
    }

    private static long internalParseDate(String value, DateTimeFormatter[] formatters) {
        for (DateTimeFormatter formatter : formatters) {
            try {
                return ZonedDateTime.parse(value, formatter).toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return -1L;
    }

    private static void updateFormatCache(Long key, String value) {
        if (value == null) {
            return;
        }
        if (formatCache.size() > 1000) {
            formatCache.clear();
        }
        formatCache.put(key, value);
    }

    private static void updateParseCache(String key, Long value) {
        if (parseCache.size() > 1000) {
            parseCache.clear();
        }
        parseCache.put(key, value);
    }

    static {
        isGeneratingNow = new AtomicBoolean();
        formatCache = new ConcurrentHashMap<Long, String>(1000, 0.75f, 64);
        parseCache = new ConcurrentHashMap<String, Long>(1000, 0.75f, 64);
    }
}

