/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.build.compatible.spi.ScopeInfo;
import jakarta.enterprise.inject.build.compatible.spi.StereotypeInfo;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.interceptor.InterceptorBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.ScopeInfoImpl;

class StereotypeInfoImpl
implements StereotypeInfo {
    private final AnnotatedType<? extends Annotation> cdiDeclaration;
    private final BeanManager bm;

    StereotypeInfoImpl(Class<? extends Annotation> stereotypeAnnotation, BeanManager bm) {
        this.cdiDeclaration = bm.createAnnotatedType(stereotypeAnnotation);
        this.bm = bm;
    }

    public ScopeInfo defaultScope() {
        Optional<AnnotatedType> scopeAnnotation = this.cdiDeclaration.getAnnotations().stream().filter(it -> it.annotationType().isAnnotationPresent(Scope.class) || it.annotationType().isAnnotationPresent(NormalScope.class)).findAny().map(it -> this.bm.createAnnotatedType(it.annotationType()));
        if (scopeAnnotation.isPresent()) {
            AnnotatedType scopeType = scopeAnnotation.get();
            boolean isNormal = scopeType.isAnnotationPresent(NormalScope.class);
            return new ScopeInfoImpl(new ClassInfoImpl(scopeType, this.bm), isNormal);
        }
        return null;
    }

    public Collection<AnnotationInfo> interceptorBindings() {
        ArrayList<AnnotationInfo> result = new ArrayList<AnnotationInfo>();
        for (Annotation annotation : this.cdiDeclaration.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(InterceptorBinding.class)) continue;
            result.add(new AnnotationInfoImpl(annotation, this.bm));
        }
        return result;
    }

    public boolean isAlternative() {
        return this.cdiDeclaration.isAnnotationPresent(Alternative.class);
    }

    public Integer priority() {
        return this.cdiDeclaration.isAnnotationPresent(Priority.class) ? Integer.valueOf(((Priority)this.cdiDeclaration.getAnnotation(Priority.class)).value()) : null;
    }

    public boolean isNamed() {
        return this.cdiDeclaration.isAnnotationPresent(Named.class);
    }
}

