/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Anchor;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.component.Legend;
import com.sun.webui.jsf.component.PropertySheet;
import com.sun.webui.jsf.component.PropertySheetSection;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public final class PropertySheetRenderer
extends Renderer {
    public static final String JUMPTOSECTIONTOOLTIP = "propertySheet.jumpToSectionTooltip";
    public static final String JUMPTOTOPTOOLTIP = "propertySheet.jumpToTopTooltip";
    public static final String JUMPTOTOP = "propertySheet.jumpToTop";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        PropertySheet propertySheet = (PropertySheet)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        String propValue = RenderingUtilities.getStyleClasses(context, component, theme.getStyleClass("PROPERTY_SHEET"));
        writer.writeAttribute("class", (Object)propValue, null);
        propValue = propertySheet.getStyle();
        if (propValue != null) {
            writer.writeAttribute("style", (Object)propValue, "style");
        }
        this.renderJumpLinks(context, propertySheet, theme, writer);
        this.renderRequiredFieldsLegend(context, propertySheet, theme, writer);
        this.renderPropertySheetSections(context, propertySheet, theme, writer);
        writer.endElement("div");
    }

    protected void renderPropertySheetSections(FacesContext context, PropertySheet propertySheet, Theme theme, ResponseWriter writer) throws IOException {
        List sections = propertySheet.getVisibleSections();
        boolean haveJumpLinks = propertySheet.isJumpLinks() && sections.size() > 1;
        boolean renderSpacer = false;
        for (Object section : sections) {
            this.renderAnchor(context, (PropertySheetSection)((Object)section), writer);
            if (haveJumpLinks || renderSpacer) {
                this.renderSpacer(context, (PropertySheetSection)((Object)section), theme, writer);
            } else {
                renderSpacer = true;
            }
            RenderingUtilities.renderComponent((UIComponent)section, context);
            if (!haveJumpLinks || sections.size() <= 1) continue;
            this.renderJumpToTopLink(context, propertySheet, theme, writer);
        }
    }

    protected void renderRequiredFieldsLegend(FacesContext context, PropertySheet propertySheet, Theme theme, ResponseWriter writer) throws IOException {
        String requiredFields = propertySheet.getRequiredFields();
        if (requiredFields != null && requiredFields.equalsIgnoreCase("true")) {
            Legend legend = new Legend();
            legend.setId(propertySheet.getId() + "_legend");
            legend.setStyleClass(theme.getStyleClass("CONTENT_REQUIRED_DIV"));
            RenderingUtilities.renderComponent((UIComponent)legend, context);
        } else {
            Icon spacer = ThemeUtilities.getIcon(theme, "DOT");
            spacer.setHeight(20);
            spacer.setWidth(1);
            RenderingUtilities.renderComponent((UIComponent)spacer, context);
        }
    }

    protected void renderJumpLinks(FacesContext context, PropertySheet propertySheet, Theme theme, ResponseWriter writer) throws IOException {
        if (!propertySheet.isJumpLinks()) {
            return;
        }
        List sections = propertySheet.getVisibleSections();
        int numSections = sections.size();
        if (numSections <= 1) {
            return;
        }
        int jumpLinksPerRow = numSections < 5 ? 5 : (numSections > 4 && numSections < 10 ? 3 : 4);
        writer.startElement("div", (UIComponent)propertySheet);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CONTENT_JUMP_SECTION_DIV"), null);
        writer.startElement("table", (UIComponent)propertySheet);
        writer.writeAttribute("border", (Object)0, null);
        writer.writeAttribute("cellspacing", (Object)0, null);
        writer.writeAttribute("cellpadding", (Object)0, null);
        writer.writeAttribute("title", (Object)"", null);
        String jumpLinkDivStyle = theme.getStyleClass("CONTENT_JUMP_LINK_DIV");
        String jumpLinkStyle = theme.getStyleClass("JUMP_LINK");
        Iterator sectionIterator = sections.iterator();
        while (sectionIterator.hasNext()) {
            writer.startElement("tr", (UIComponent)propertySheet);
            for (int i = 0; i < jumpLinksPerRow; ++i) {
                PropertySheetSection section = (PropertySheetSection)((Object)sectionIterator.next());
                writer.startElement("td", (UIComponent)propertySheet);
                writer.startElement("span", (UIComponent)propertySheet);
                writer.writeAttribute("class", (Object)jumpLinkDivStyle, null);
                IconHyperlink jumpLink = new IconHyperlink();
                jumpLink.setId(section.getId() + "_jumpLink");
                jumpLink.setParent((UIComponent)propertySheet);
                jumpLink.setIcon("HREF_ANCHOR");
                jumpLink.setBorder(0);
                String propValue = theme.getMessage(JUMPTOSECTIONTOOLTIP);
                if (propValue != null) {
                    jumpLink.setAlt(propValue);
                    jumpLink.setToolTip(propValue);
                }
                if ((propValue = section.getLabel()) != null) {
                    jumpLink.setText(propValue);
                }
                jumpLink.setUrl("#_" + section.getId());
                jumpLink.setStyleClass(jumpLinkStyle);
                RenderingUtilities.renderComponent((UIComponent)jumpLink, context);
                writer.endElement("span");
                writer.endElement("td");
                if (sectionIterator.hasNext()) continue;
                while (++i < jumpLinksPerRow) {
                    writer.startElement("td", (UIComponent)propertySheet);
                    writer.startElement("span", (UIComponent)propertySheet);
                    writer.writeAttribute("class", (Object)jumpLinkDivStyle, null);
                    writer.endElement("span");
                    writer.endElement("td");
                }
                break;
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    private void renderAnchor(FacesContext context, PropertySheetSection propertySheetSection, ResponseWriter writer) throws IOException {
        Anchor anchor = new Anchor();
        anchor.setParent((UIComponent)propertySheetSection);
        anchor.setId("_" + propertySheetSection.getId());
        RenderingUtilities.renderComponent((UIComponent)anchor, context);
    }

    private void renderSpacer(FacesContext context, PropertySheetSection propertySheetSection, Theme theme, ResponseWriter writer) throws IOException {
        Icon spacer = ThemeUtilities.getIcon(theme, "DOT");
        writer.startElement("div", (UIComponent)propertySheetSection);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CONTENT_LIN"), null);
        spacer.setId(propertySheetSection.getId() + "_dot1");
        spacer.setParent((UIComponent)propertySheetSection);
        spacer.setHeight(1);
        spacer.setWidth(1);
        RenderingUtilities.renderComponent((UIComponent)spacer, context);
        writer.endElement("div");
    }

    private void renderJumpToTopLink(FacesContext context, PropertySheet propertySheet, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)propertySheet);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CONTENT_JUMP_TOP_DIV"), null);
        IconHyperlink jumpLink = new IconHyperlink();
        jumpLink.setIcon("HREF_TOP");
        jumpLink.setBorder(0);
        String propValue = theme.getMessage(JUMPTOTOPTOOLTIP);
        if (propValue != null) {
            jumpLink.setAlt(propValue);
            jumpLink.setToolTip(propValue);
        }
        if ((propValue = theme.getMessage(JUMPTOTOP)) != null) {
            jumpLink.setText(propValue);
        }
        jumpLink.setUrl("#");
        jumpLink.setStyleClass(theme.getStyleClass("JUMP_TOP_LINK"));
        RenderingUtilities.renderComponent((UIComponent)jumpLink, context);
        writer.endElement("div");
    }
}

