/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ResourceDeployerInfo(value=JdbcResource.class)
public class JdbcResourceDeployer
implements ResourceDeployer<JdbcResource> {
    private static final Logger LOG = LogDomains.getLogger(JdbcResourceDeployer.class, (String)"jakarta.enterprise.resource.resourceadapter");
    @Inject
    private ConnectorRuntime runtime;

    public boolean handles(Object resource) {
        return resource instanceof JdbcResource;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    public void deployResource(JdbcResource resource) throws Exception {
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public synchronized void deployResource(JdbcResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = new SimpleJndiName(resource.getJndiName());
        SimpleJndiName poolName = new SimpleJndiName(resource.getPoolName());
        PoolInfo poolInfo = new PoolInfo(poolName, applicationName, moduleName);
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
        if (ConnectorsUtil.getValidSuffix((SimpleJndiName)jndiName) == null) {
            ResourceInfo pmResourceInfo = new ResourceInfo(ConnectorsUtil.getPMJndiName((SimpleJndiName)jndiName), resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.createConnectorResource(pmResourceInfo, poolInfo, null);
        }
        LOG.log(Level.FINEST, "Deployed resource {0}", jndiName);
    }

    public synchronized void undeployResource(JdbcResource resource) throws Exception {
        this.deleteResource(resource, ConnectorsUtil.getResourceInfo((BindableResource)resource));
    }

    public void undeployResource(JdbcResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = new SimpleJndiName(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.deleteResource(resource, resourceInfo);
    }

    public synchronized void enableResource(JdbcResource resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(JdbcResource resource) throws Exception {
        this.undeployResource(resource);
    }

    private void deleteResource(JdbcResource jdbcResource, ResourceInfo resourceInfo) throws Exception {
        this.runtime.deleteConnectorResource(resourceInfo);
        ConnectorRegistry.getInstance().removeResourceFactories(resourceInfo);
        if (ConnectorsUtil.getValidSuffix((SimpleJndiName)resourceInfo.getName()) == null) {
            SimpleJndiName pmJndiName = ConnectorsUtil.getPMJndiName((SimpleJndiName)resourceInfo.getName());
            ResourceInfo pmResourceInfo = new ResourceInfo(pmJndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
            this.runtime.deleteConnectorResource(pmResourceInfo);
            ConnectorRegistry.getInstance().removeResourceFactories(pmResourceInfo);
        }
        this.checkAndDeletePool(jdbcResource);
    }

    private void checkAndDeletePool(JdbcResource jdbcResource) throws Exception {
        boolean poolReferred;
        SimpleJndiName poolName = new SimpleJndiName(jdbcResource.getPoolName());
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)jdbcResource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        Resources resources = (Resources)jdbcResource.getParent();
        if (resources != null && !(poolReferred = JdbcResourcesUtil.createInstance().isJdbcPoolReferredInServerInstance(poolInfo))) {
            LOG.fine(() -> "Deleting JDBC pool [" + String.valueOf(poolName) + " ] as there are no more resource-refs to the pool in this server instance");
            JdbcConnectionPool jcp = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, poolName);
            this.runtime.getResourceDeployer((Object)jcp).undeployResource((Object)jcp);
        }
    }
}

