/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import jakarta.validation.Path;
import java.util.Map;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.messageinterpolation.ExpressionLanguageFeatureLevel;

public class ConstraintViolationCreationContext {
    private final String message;
    private final ExpressionLanguageFeatureLevel expressionLanguageFeatureLevel;
    private final boolean customViolation;
    private final Path propertyPath;
    private final Map<String, Object> messageParameters;
    private final Map<String, Object> expressionVariables;
    private final Object dynamicPayload;

    public ConstraintViolationCreationContext(String message, ExpressionLanguageFeatureLevel expressionLanguageFeatureLevel, boolean customViolation, MutablePath property, Map<String, Object> messageParameters, Map<String, Object> expressionVariables, Object dynamicPayload) {
        this.message = message;
        this.expressionLanguageFeatureLevel = expressionLanguageFeatureLevel;
        this.customViolation = customViolation;
        this.propertyPath = property.materialize();
        this.messageParameters = messageParameters;
        this.expressionVariables = expressionVariables;
        this.dynamicPayload = dynamicPayload;
    }

    public final String getMessage() {
        return this.message;
    }

    public ExpressionLanguageFeatureLevel getExpressionLanguageFeatureLevel() {
        return this.expressionLanguageFeatureLevel;
    }

    public boolean isCustomViolation() {
        return this.customViolation;
    }

    public final Path getPath() {
        return this.propertyPath;
    }

    public Map<String, Object> getMessageParameters() {
        return this.messageParameters;
    }

    public Map<String, Object> getExpressionVariables() {
        return this.expressionVariables;
    }

    public Object getDynamicPayload() {
        return this.dynamicPayload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConstraintViolationCreationContext{");
        sb.append("message='").append(this.message).append('\'');
        sb.append(", expressionLanguageFeatureLevel=").append((Object)this.expressionLanguageFeatureLevel);
        sb.append(", customViolation=").append(this.customViolation);
        sb.append(", propertyPath=").append(this.propertyPath);
        sb.append(", messageParameters=").append(this.messageParameters);
        sb.append(", expressionVariables=").append(this.expressionVariables);
        sb.append(", dynamicPayload=").append(this.dynamicPayload);
        sb.append('}');
        return sb.toString();
    }
}

