/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Field;

public class XPathFragment<XML_FIELD extends Field> {
    public static final XPathFragment TEXT_FRAGMENT = new XPathFragment("text()");
    public static final String SELF_XPATH = ".";
    public static final XPathFragment SELF_FRAGMENT = new XPathFragment(".");
    public static final XPathFragment ANY_FRAGMENT = null;
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private XPathFragment nextFragment;
    private XML_FIELD xmlField;
    private String xpath;
    protected boolean hasAttribute = false;
    private boolean hasText = false;
    private boolean hasNamespace = false;
    private boolean containsIndex = false;
    private int indexValue = -1;
    private boolean shouldExecuteSelectNodes = false;
    private String shortName;
    private String prefix;
    private byte[] prefixBytes;
    private String localName;
    private byte[] localNameBytes;
    private String namespaceURI;
    protected boolean nameIsText = false;
    protected boolean isSelfFragment = false;
    private QName leafElementType;
    private boolean generatedPrefix = false;
    private XPathPredicate predicate;
    private boolean namespaceAware;
    private char namespaceSeparator;
    private Set<String> attributeCollisionSet;
    private Set<String> nonAttributeCollisionSet;

    public XPathFragment() {
        this.setNamespaceAware(true);
        this.namespaceSeparator = (char)58;
    }

    public XPathFragment(String xpathString) {
        this(xpathString, ':', true);
    }

    public XPathFragment(String xpathString, char namespaceSeparator, boolean namespaceAware) {
        this.namespaceSeparator = namespaceSeparator;
        this.setNamespaceAware(namespaceAware);
        this.setXPath(xpathString);
    }

    public void setPredicate(XPathPredicate condition) {
        this.predicate = condition;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this.namespaceAware = isNamespaceAware;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeparator = namespaceSeparator;
    }

    public XPathPredicate getPredicate() {
        return this.predicate;
    }

    public XPathFragment getNextFragment() {
        return this.nextFragment;
    }

    public void setNextFragment(XPathFragment nextFragment) {
        this.nextFragment = nextFragment;
    }

    public void setXPath(String xpathString) {
        this.xpath = xpathString;
        this.shortName = xpathString;
        if (!xpathString.isEmpty()) {
            if (this.xpath.indexOf(91) != -1 && this.xpath.indexOf(93) == -1) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (this.xpath.contains("::")) {
                this.setShouldExecuteSelectNodes(true);
                return;
            }
            if (xpathString.charAt(0) == '@') {
                this.hasAttribute = true;
                this.shortName = xpathString.substring(1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
            if (xpathString.charAt(0) == '/') {
                this.setShouldExecuteSelectNodes(true);
                this.shortName = xpathString.substring(xpathString.lastIndexOf(47) + 1).intern();
                this.indexValue = this.hasIndex(xpathString);
                this.setupNamespaceInformation(this.shortName);
                return;
            }
        }
        if (xpathString.equals("text()")) {
            this.nameIsText = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.nameIsText = false;
        if (xpathString.equals(SELF_XPATH)) {
            this.isSelfFragment = true;
            this.shortName = xpathString.intern();
            return;
        }
        this.indexValue = this.hasIndex(xpathString);
        this.setupNamespaceInformation(this.shortName);
    }

    private void setupNamespaceInformation(String xpathString) {
        int nsindex = xpathString.indexOf(this.namespaceSeparator);
        if (nsindex != -1) {
            this.hasNamespace = true;
            this.localName = xpathString.substring(nsindex + 1).intern();
            this.prefix = xpathString.substring(0, nsindex).intern();
        } else {
            this.localName = xpathString.intern();
        }
    }

    public boolean isAttribute() {
        return this.hasAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.hasAttribute = isAttribute;
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.shortName = this.prefix != null && !this.prefix.isEmpty() ? this.prefix + ":" + this.localName : this.localName;
        }
        return this.shortName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public byte[] getPrefixBytes() {
        if (null == this.prefixBytes && null != this.prefix) {
            this.prefixBytes = this.prefix.getBytes(CHARSET);
        }
        return this.prefixBytes;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.resetShortName();
    }

    public String getLocalName() {
        return this.localName;
    }

    public byte[] getLocalNameBytes() {
        if (null == this.localNameBytes && null != this.localName) {
            this.localNameBytes = this.localName.getBytes(CHARSET);
        }
        return this.localNameBytes;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
        this.resetShortName();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = this.isSelfFragment || namespaceURI != null && namespaceURI.isEmpty() ? null : namespaceURI;
    }

    private int hasIndex(String xpathString) {
        int index = -1;
        int startindex = xpathString.lastIndexOf(91);
        if (startindex != -1 && xpathString.lastIndexOf(93) != -1) {
            StringTokenizer st = new StringTokenizer(xpathString, "[]");
            String element = st.nextToken();
            while (st.hasMoreTokens()) {
                String indexString = st.nextToken();
                try {
                    index = Integer.parseInt(indexString);
                    this.setContainsIndex(true);
                }
                catch (NumberFormatException e) {
                    int equalsOffset = indexString.indexOf(61);
                    if (equalsOffset >= 0) {
                        XPathFragment<XML_FIELD> xPathFragment = new XPathFragment<XML_FIELD>(indexString.substring(0, equalsOffset));
                        String value = indexString.substring(equalsOffset + 2, indexString.length() - 1);
                        this.predicate = new XPathPredicate(xPathFragment, value);
                    } else {
                        this.setContainsIndex(true);
                    }
                    this.setShouldExecuteSelectNodes(true);
                }
            }
            this.shortName = element;
        } else {
            index = -1;
        }
        return index;
    }

    public int getIndexValue() {
        return this.indexValue;
    }

    public void setIndexValue(int indexValue) {
        this.indexValue = indexValue;
    }

    public String getXPath() {
        return this.xpath;
    }

    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    public boolean isSelfFragment() {
        return this.isSelfFragment;
    }

    public boolean nameIsText() {
        return this.nameIsText;
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean getHasText() {
        return this.hasText;
    }

    public void setContainsIndex(boolean containsIndex) {
        this.containsIndex = containsIndex;
    }

    public boolean containsIndex() {
        return this.containsIndex;
    }

    public void setShouldExecuteSelectNodes(boolean newShouldExecuteSelectNodes) {
        this.shouldExecuteSelectNodes = newShouldExecuteSelectNodes;
    }

    public boolean shouldExecuteSelectNodes() {
        return this.shouldExecuteSelectNodes;
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean ignorePredicate) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            XPathFragment xPathFragment = (XPathFragment)object;
            if (this.hasAttribute && !xPathFragment.hasAttribute) {
                return false;
            }
            if (this.nameIsText && xPathFragment.nameIsText) {
                return true;
            }
            if (this.nameIsText != xPathFragment.nameIsText) {
                return false;
            }
            if (null == this.localName && null != xPathFragment.localName || null != this.localName && null == xPathFragment.localName) {
                return false;
            }
            if (null != this.localName && !this.localName.equals(xPathFragment.localName)) {
                return false;
            }
            if (this.namespaceAware && xPathFragment.isNamespaceAware()) {
                if (null == this.namespaceURI && null != xPathFragment.namespaceURI || null != this.namespaceURI && null == xPathFragment.namespaceURI) {
                    return false;
                }
                if (null != this.namespaceURI && !this.namespaceURI.equals(xPathFragment.namespaceURI)) {
                    return false;
                }
            }
            if (this.indexValue != xPathFragment.indexValue) {
                return false;
            }
            if (!ignorePredicate) {
                if (null == this.predicate && null != xPathFragment.predicate) {
                    return false;
                }
                if (null != this.predicate && !this.predicate.equals(xPathFragment.predicate)) {
                    return false;
                }
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (null == this.localName) {
            return 1;
        }
        return this.localName.hashCode();
    }

    public QName getLeafElementType() {
        return this.leafElementType;
    }

    public boolean hasLeafElementType() {
        return this.leafElementType != null;
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
    }

    public void setGeneratedPrefix(boolean isGenerated) {
        this.generatedPrefix = isGenerated;
    }

    public boolean isGeneratedPrefix() {
        return this.generatedPrefix;
    }

    public XML_FIELD getXMLField() {
        return this.xmlField;
    }

    public void setXMLField(XML_FIELD field) {
        this.xmlField = field;
    }

    private void resetShortName() {
        this.shortName = null;
        this.prefixBytes = null;
        this.localNameBytes = null;
    }

    public Set<String> getChildrenCollisionSet(boolean isAttribute) {
        return isAttribute ? this.getAttributeCollisionSet() : this.getNonAttributeCollisionSet();
    }

    private Set<String> getAttributeCollisionSet() {
        if (this.attributeCollisionSet == null) {
            this.attributeCollisionSet = new HashSet<String>();
        }
        return this.attributeCollisionSet;
    }

    private Set<String> getNonAttributeCollisionSet() {
        if (this.nonAttributeCollisionSet == null) {
            this.nonAttributeCollisionSet = new HashSet<String>();
        }
        return this.nonAttributeCollisionSet;
    }
}

