/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.cache;

import java.util.function.Function;
import org.jboss.weld.util.WeakLazyValueHolder;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ReentrantMapBackedComputingCache;

public final class ComputingCacheBuilder {
    private Long maxSize;
    private boolean weakValues;

    private ComputingCacheBuilder() {
    }

    public static ComputingCacheBuilder newBuilder() {
        return new ComputingCacheBuilder();
    }

    public ComputingCacheBuilder setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public ComputingCacheBuilder setWeakValues() {
        this.weakValues = true;
        return this;
    }

    public <K, V> ComputingCache<K, V> build(Function<K, V> computingFunction) {
        if (this.weakValues) {
            return new ReentrantMapBackedComputingCache<K, V>(computingFunction, WeakLazyValueHolder::forSupplier, this.maxSize);
        }
        return new ReentrantMapBackedComputingCache<K, V>(computingFunction, this.maxSize);
    }
}

