/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.ConditionVars;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class WhileStatement
extends Statement {
    Expression cond;
    Statement body;

    public WhileStatement(long where, Expression cond, Statement body) {
        super(93, where);
        this.cond = cond;
        this.body = body;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        CheckContext newctx = new CheckContext(ctx, this);
        Vset vsEntry = vset.copy();
        ConditionVars cvars = this.cond.checkCondition(env, newctx, this.reach(env, vset), exp);
        this.cond = this.convert(env, newctx, Type.tBoolean, this.cond);
        vset = this.body.check(env, newctx, cvars.vsTrue, exp);
        vset = vset.join(newctx.vsContinue);
        ctx.checkBackBranch(env, this, vsEntry, vset);
        vset = newctx.vsBreak.join(cvars.vsFalse);
        return ctx.removeAdditionalVars(vset);
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        ctx = new Context(ctx, this);
        this.cond = this.cond.inlineValue(env, ctx);
        if (this.body != null) {
            this.body = this.body.inline(env, ctx);
        }
        return this;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + this.cond.costInline(thresh, env, ctx) + (this.body != null ? this.body.costInline(thresh, env, ctx) : 0);
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        WhileStatement s = (WhileStatement)this.clone();
        s.cond = this.cond.copyInline(ctx);
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        asm.add(this.where, 167, newctx.contLabel);
        Label l1 = new Label();
        asm.add(l1);
        if (this.body != null) {
            this.body.code(env, newctx, asm);
        }
        asm.add(newctx.contLabel);
        this.cond.codeBranch(env, newctx, asm, l1, true);
        asm.add(newctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("while ");
        this.cond.print(out);
        if (this.body != null) {
            out.print(" ");
            this.body.print(out, indent);
        } else {
            out.print(";");
        }
    }
}

