/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public final class UploadFilter
implements Filter {
    public static final String MAX_SIZE = "maxSize";
    public static final String SIZE_THRESHOLD = "sizeThreshold";
    public static final String TMP_DIR = "tmpDir";
    private long maxSize = 1000000L;
    private int sizeThreshold = 4096;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private static final String MESSAGES = "com.sun.webui.jsf.resources.LogMessages";
    private static final boolean DEBUG = false;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (ServletFileUpload.isMultipartContent(req)) {
            ServletFileUpload fu = new ServletFileUpload(new DiskFileItemFactory(this.sizeThreshold, new File(this.tmpDir)));
            fu.setSizeMax(this.maxSize);
            if (request.getCharacterEncoding() != null) {
                fu.setHeaderEncoding(request.getCharacterEncoding());
            } else {
                fu.setHeaderEncoding("UTF-8");
            }
            List<FileItem> fileItems = null;
            try {
                fileItems = fu.parseRequest(req);
            }
            catch (FileUploadException fue) {
                request.setAttribute("upload_error_key", (Object)fue);
                request.setAttribute("file_size_key", (Object)String.valueOf(this.maxSize));
            }
            HashMap<Object, Object> parameters = fileItems != null ? this.parseRequest(fileItems, req) : new HashMap();
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String param = (String)names.nextElement();
                String paramValue = request.getParameter(param);
                if (!parameters.containsKey(param)) {
                    parameters.put(param, new String[]{paramValue});
                    continue;
                }
                String[] origParamValue = parameters.get(param);
                List<String> paramList = Arrays.asList(origParamValue);
                paramList.add(paramValue);
                String[] newParamValue = paramList.toArray(new String[0]);
                parameters.put(param, newParamValue);
            }
            UploadRequest wrappedRequest = new UploadRequest(req, parameters);
            chain.doFilter((ServletRequest)wrappedRequest, response);
            Enumeration e = request.getAttributeNames();
            while (e.hasMoreElements()) {
                Object o = request.getAttribute(e.nextElement().toString());
                if (!(o instanceof FileItem)) continue;
                ((FileItem)o).delete();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private HashMap<String, String[]> parseRequest(List<FileItem> fileItems, HttpServletRequest request) {
        FileItem fileItem;
        Iterator<FileItem> fileItemsIt = fileItems.iterator();
        TreeMap fileItemsMap = new TreeMap();
        while (fileItemsIt.hasNext()) {
            fileItem = fileItemsIt.next();
            String fieldID = fileItem.getFieldName();
            if (fieldID.endsWith("_com.sun.webui.jsf.upload")) {
                request.setAttribute(fieldID, (Object)fileItem);
                continue;
            }
            List valueList = !fileItemsMap.containsKey(fieldID) ? new ArrayList() : (List)fileItemsMap.get(fieldID);
            valueList.add(fileItem);
            fileItemsMap.put(fieldID, valueList);
        }
        ArrayList<String> removes = new ArrayList<String>();
        ArrayList<String> unlabeledUploads = new ArrayList<String>();
        for (String fieldID : fileItemsMap.keySet()) {
            if (!fieldID.endsWith("_com.sun.webui.jsf.uploadParam")) continue;
            fileItem = (FileItem)((ArrayList)fileItemsMap.get(fieldID)).get(0);
            String param = fileItem.getString();
            unlabeledUploads.add(param);
            removes.add(fieldID);
        }
        if (!unlabeledUploads.isEmpty()) {
            for (String fieldID : unlabeledUploads) {
                if (fileItemsMap.get(fieldID) == null) continue;
                fileItem = (FileItem)((List)fileItemsMap.get(fieldID)).get(0);
                request.setAttribute(fieldID.concat("_com.sun.webui.jsf.upload"), (Object)fileItem);
                removes.add(fieldID);
            }
        }
        if (!removes.isEmpty()) {
            Iterator removesIterator = removes.iterator();
            while (removesIterator.hasNext()) {
                fileItemsMap.remove(removesIterator.next());
            }
        }
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        for (String id : fileItemsMap.keySet()) {
            ArrayList valueList = (ArrayList)fileItemsMap.get(id);
            if (valueList.size() == 1) {
                parameters.put(id, new String[]{((FileItem)valueList.get(0)).getString()});
                continue;
            }
            String[] params = new String[valueList.size()];
            for (int i = 0; i < valueList.size(); ++i) {
                params[i] = ((FileItem)valueList.get(i)).getString();
            }
            parameters.put(id, params);
        }
        return parameters;
    }

    public void init(FilterConfig filterConfig) {
        String error;
        String msg;
        Object[] params;
        StringBuilder errorMessageBuffer = new StringBuilder();
        String param = filterConfig.getInitParameter(MAX_SIZE);
        if (param != null) {
            try {
                this.maxSize = Long.parseLong(param);
            }
            catch (NumberFormatException nfe) {
                params = new Object[]{MAX_SIZE, param};
                msg = MessageUtil.getMessage(MESSAGES, "Upload.invalidLong", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((param = filterConfig.getInitParameter(SIZE_THRESHOLD)) != null) {
            try {
                this.sizeThreshold = Integer.parseInt(param);
            }
            catch (NumberFormatException nfe) {
                params = new Object[]{SIZE_THRESHOLD, param};
                errorMessageBuffer.append(" ");
                msg = MessageUtil.getMessage(MESSAGES, "Upload.invalidInt", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((param = filterConfig.getInitParameter(TMP_DIR)) != null) {
            this.tmpDir = param;
            File dir = new File(this.tmpDir);
            if (!dir.canWrite()) {
                params = new Object[]{TMP_DIR, param};
                errorMessageBuffer.append(" ");
                msg = MessageUtil.getMessage(MESSAGES, "Upload.invalidDir", params);
                errorMessageBuffer.append(msg);
            }
        }
        if ((error = errorMessageBuffer.toString()).length() > 0) {
            throw new RuntimeException(error);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void destroy() {
    }

    private static void log(String msg) {
        LogUtil.finest(UploadFilter.class.getName() + "::" + msg);
    }

    private static final class UploadRequest
    extends HttpServletRequestWrapper {
        private final Map<String, String[]> parameters;

        UploadRequest(HttpServletRequest request, Map<String, String[]> params) {
            super(request);
            this.parameters = params;
        }

        public String getParameter(String name) {
            String[] param = this.parameters.get(name);
            if (param instanceof String) {
                return (String)param;
            }
            if (param instanceof String[]) {
                String[] params = param;
                return params[0];
            }
            if (param == null) {
                return null;
            }
            return param.toString();
        }

        public String[] getParameterValues(String name) {
            String[] value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return value;
            }
            return new String[]{value.toString()};
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parameters.keySet());
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }
    }
}

