/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

class IndexChanger {
    private final IndexRowGenerator irg;
    private final long indexCID;
    private final DynamicCompiledOpenConglomInfo indexDCOCI;
    private final StaticCompiledOpenConglomInfo indexSCOCI;
    private final String indexName;
    private ConglomerateController baseCC;
    private final TransactionController tc;
    private final int lockMode;
    private final FormatableBitSet baseRowReadMap;
    private ConglomerateController indexCC = null;
    private ScanController indexSC = null;
    private ExecIndexRow ourIndexRow = null;
    private ExecIndexRow ourUpdatedIndexRow = null;
    private TemporaryRowHolderImpl rowHolder = null;
    private boolean rowHolderPassedIn;
    private int isolationLevel;
    private final Activation activation;
    private boolean ownIndexSC = true;
    private final boolean deferrable;
    private final LanguageConnectionContext lcc;
    private BackingStoreHashtable deferredDuplicates;
    private UUID uniqueConstraintId;

    IndexChanger(IndexRowGenerator indexRowGenerator, long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo, String string, ConglomerateController conglomerateController, TransactionController transactionController, int n, FormatableBitSet formatableBitSet, int n2, Activation activation) throws StandardException {
        this.irg = indexRowGenerator;
        this.deferrable = indexRowGenerator.hasDeferrableChecking();
        this.indexCID = l;
        this.indexSCOCI = staticCompiledOpenConglomInfo;
        this.indexDCOCI = dynamicCompiledOpenConglomInfo;
        this.baseCC = conglomerateController;
        this.tc = transactionController;
        this.lockMode = n;
        this.baseRowReadMap = formatableBitSet;
        this.rowHolderPassedIn = false;
        this.isolationLevel = n2;
        this.activation = activation;
        this.indexName = string;
        LanguageConnectionContext languageConnectionContext = this.lcc = activation != null ? activation.getLanguageConnectionContext() : null;
        if (activation != null && activation.getIndexConglomerateNumber() == l) {
            this.ownIndexSC = false;
        }
    }

    void setRowHolder(TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.rowHolder = temporaryRowHolderImpl;
        this.rowHolderPassedIn = temporaryRowHolderImpl != null;
    }

    void setBaseCC(ConglomerateController conglomerateController) {
        this.baseCC = conglomerateController;
    }

    private void setOurIndexRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.ourIndexRow == null) {
            this.ourIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(execRow, rowLocation, this.ourIndexRow, this.baseRowReadMap);
    }

    private void setOurUpdatedIndexRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.ourUpdatedIndexRow == null) {
            this.ourUpdatedIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(execRow, rowLocation, this.ourUpdatedIndexRow, this.baseRowReadMap);
    }

    private boolean indexRowChanged() throws StandardException {
        int n = this.ourIndexRow.nColumns();
        for (int i = 1; i <= n; ++i) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = this.ourIndexRow.getColumn(i);
            if (dataValueDescriptor2.compare(2, dataValueDescriptor = this.ourUpdatedIndexRow.getColumn(i), true, true)) continue;
            return true;
        }
        return false;
    }

    private void setScan() throws StandardException {
        if (!this.ownIndexSC) {
            this.indexSC = this.activation.getIndexScanController();
        } else if (this.indexSC == null) {
            RowLocation rowLocation = this.baseCC.newRowLocationTemplate();
            this.indexSC = this.indexSCOCI == null ? this.tc.openScan(this.indexCID, false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1) : this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, this.indexSCOCI, this.indexDCOCI);
        } else {
            this.indexSC.reopenScan(this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1);
        }
    }

    private void closeIndexCC() throws StandardException {
        if (this.indexCC != null) {
            this.indexCC.close();
        }
        this.indexCC = null;
    }

    private void closeIndexSC() throws StandardException {
        if (this.ownIndexSC && this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
    }

    private void doDelete() throws StandardException {
        if (this.ownIndexSC && !this.indexSC.next()) {
            Object[] objectArray = new Object[]{this.ourIndexRow.getRowArray()[this.ourIndexRow.getRowArray().length - 1], this.indexCID};
            Monitor.getStream().println(MessageService.getTextMessage("X0Y83.S", objectArray));
            return;
        }
        this.indexSC.delete();
    }

    private void doInsert() throws StandardException {
        this.insertAndCheckDups(this.ourIndexRow);
    }

    private void doDeferredInsert() throws StandardException {
        if (this.rowHolder == null) {
            Properties properties = new Properties();
            this.openIndexCC().getInternalTablePropertySet(properties);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, null);
        }
        if (!this.rowHolderPassedIn) {
            this.rowHolder.insert(this.ourIndexRow);
        }
    }

    private UUID getUniqueConstraintId() throws StandardException {
        if (this.uniqueConstraintId == null) {
            DataDictionary dataDictionary = this.lcc.getDataDictionary();
            ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexCID);
            this.uniqueConstraintId = dataDictionary.getConstraintDescriptor(dataDictionary.getTableDescriptor(conglomerateDescriptor.getTableID()), conglomerateDescriptor.getUUID()).getUUID();
        }
        return this.uniqueConstraintId;
    }

    private void insertAndCheckDups(ExecIndexRow execIndexRow) throws StandardException {
        Object object;
        DataValueDescriptor[] dataValueDescriptorArray;
        int n;
        this.openIndexCC();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow.getRowArray();
        if (this.deferrable) {
            int n2;
            n = this.indexCC.insert(execIndexRow.getRowArray());
            dataValueDescriptorArray = new DataValueDescriptor[dataValueDescriptorArray2.length - 1];
            System.arraycopy(dataValueDescriptorArray2, 0, dataValueDescriptorArray, 0, dataValueDescriptorArray.length);
            boolean bl = this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(this.activation), this.getUniqueConstraintId());
            object = this.tc.openScan(this.indexCID, false, bl ? 32768 : 0, 6, 3, null, dataValueDescriptorArray, 1, null, dataValueDescriptorArray, -1);
            boolean bl2 = false;
            try {
                n2 = object.next();
                bl2 = n2 != 0 && object.next();
            }
            catch (StandardException standardException) {
                if ((standardException.getSQLState().equals("40XL1") || standardException.getSQLState().equals("40001")) && bl) {
                    bl2 = true;
                }
                throw standardException;
            }
            if (bl2 && this.irg.isUniqueWithDuplicateNulls()) {
                n2 = dataValueDescriptorArray2.length - 1;
                for (int i = 0; i < n2; ++i) {
                    if (!dataValueDescriptorArray2[i].isNull()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                if (bl) {
                    this.deferredDuplicates = DeferredConstraintsMemory.rememberDuplicate(this.lcc, this.deferredDuplicates, this.getUniqueConstraintId(), execIndexRow.getRowArray());
                } else {
                    n = 1;
                }
            }
        } else {
            n = this.indexCC.insert(execIndexRow.getRowArray());
        }
        if (n == 1) {
            Object object2;
            dataValueDescriptorArray = this.indexName;
            LanguageConnectionContext languageConnectionContext = this.activation.getLanguageConnectionContext();
            object = languageConnectionContext.getDataDictionary();
            ConglomerateDescriptor conglomerateDescriptor = object.getConglomerateDescriptor(this.indexCID);
            UUID uUID = conglomerateDescriptor.getTableID();
            TableDescriptor tableDescriptor = object.getTableDescriptor(uUID);
            String string = tableDescriptor.getName();
            if (dataValueDescriptorArray == null) {
                object2 = object.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                dataValueDescriptorArray = ((ConstraintDescriptor)object2).getConstraintName();
            }
            object2 = StandardException.newException("23505", dataValueDescriptorArray, string);
            throw object2;
        }
    }

    private ConglomerateController openIndexCC() throws StandardException {
        if (this.indexCC == null) {
            this.indexCC = this.indexSCOCI == null ? this.tc.openConglomerate(this.indexCID, false, 16388, this.lockMode, this.isolationLevel) : this.tc.openCompiledConglomerate(false, 16388, this.lockMode, this.isolationLevel, this.indexSCOCI, this.indexDCOCI);
        }
        return this.indexCC;
    }

    void open() throws StandardException {
    }

    void delete(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.setScan();
        this.doDelete();
    }

    void update(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.setOurUpdatedIndexRow(execRow2, rowLocation);
        if (this.indexRowChanged()) {
            this.setScan();
            this.doDelete();
            this.insertForUpdate(execRow2, rowLocation);
        }
    }

    void insert(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.doInsert();
    }

    void insertForUpdate(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        if (this.irg.isUnique() || this.irg.isUniqueWithDuplicateNulls() || this.irg.hasDeferrableChecking()) {
            this.doDeferredInsert();
        } else {
            this.doInsert();
        }
    }

    void finish() throws StandardException {
        if (this.rowHolder != null) {
            CursorResultSet cursorResultSet = this.rowHolder.getResultSet();
            try {
                ExecRow execRow;
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.insertAndCheckDups((ExecIndexRow)execRow);
                }
            }
            finally {
                cursorResultSet.close();
                if (!this.rowHolderPassedIn) {
                    this.rowHolder.close();
                }
            }
        }
    }

    void close() throws StandardException {
        this.closeIndexCC();
        this.closeIndexSC();
        if (this.rowHolder != null && !this.rowHolderPassedIn) {
            this.rowHolder.close();
        }
        this.baseCC = null;
    }
}

