/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

public class PositionChecker
implements ModelDeserializer<JsonParser> {
    private static final Map<JsonParser.Event, JsonParser.Event> CLOSING_EVENTS = Map.of(JsonParser.Event.START_ARRAY, JsonParser.Event.END_ARRAY, JsonParser.Event.START_OBJECT, JsonParser.Event.END_OBJECT);
    private final Set<JsonParser.Event> expectedEvents;
    private final ModelDeserializer<JsonParser> delegate;
    private final Type rType;

    public PositionChecker(ModelDeserializer<JsonParser> delegate, Type rType, Checker checker) {
        this(checker.events, delegate, rType);
    }

    public PositionChecker(ModelDeserializer<JsonParser> delegate, Type rType, JsonParser.Event ... events) {
        this(Set.copyOf(Arrays.asList(events)), delegate, rType);
    }

    private PositionChecker(Set<JsonParser.Event> expectedEvents, ModelDeserializer<JsonParser> delegate, Type rType) {
        this.expectedEvents = expectedEvents;
        this.delegate = delegate;
        this.rType = rType;
    }

    @Override
    public Object deserialize(JsonParser value, DeserializationContextImpl context) {
        JsonParser.Event original = context.getLastValueEvent();
        JsonParser.Event startEvent = original;
        if (!this.expectedEvents.contains(startEvent)) {
            startEvent = value.next();
            context.setLastValueEvent(startEvent);
            if (!this.expectedEvents.contains(startEvent)) {
                throw new JsonbException("Incorrect position for processing type: " + this.rType + ". Received event: " + original + " Allowed: " + this.expectedEvents);
            }
        }
        Object o = this.delegate.deserialize(value, context);
        if (CLOSING_EVENTS.containsKey(startEvent) && CLOSING_EVENTS.get(startEvent) != context.getLastValueEvent()) {
            throw new JsonbException("Incorrect parser position after processing of the type: " + this.rType + ". Start event: " + startEvent + " After processing event: " + context.getLastValueEvent());
        }
        return o;
    }

    public String toString() {
        return "PositionChecker{expectedEvents=" + this.expectedEvents + ", runtimeType=" + this.rType + "}";
    }

    public static enum Checker {
        VALUES(JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_NULL),
        CONTAINER(JsonParser.Event.START_OBJECT, JsonParser.Event.START_ARRAY);

        private final Set<JsonParser.Event> events;

        private Checker(JsonParser.Event ... events) {
            this.events = Set.of(events);
        }

        public Set<JsonParser.Event> getEvents() {
            return this.events;
        }
    }
}

