/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.queries.ReportQuery;

public class SubqueryNode
extends Node {
    private JPQLParseTree subqueryParseTree;
    private Set<String> outerVars;

    public ReportQuery getReportQuery(GenerationContext context) {
        ReportQuery innerQuery = new ReportQuery();
        GenerationContext innerContext = this.subqueryParseTree.populateSubquery(innerQuery, context);
        Expression joins = innerContext.joinVariables(this.outerVars);
        if (joins != null) {
            Expression where = innerQuery.getSelectionCriteria();
            where = this.appendExpression(where, joins);
            innerQuery.setSelectionCriteria(where);
        }
        return innerQuery;
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        this.subqueryParseTree.getFromNode().qualifyAttributeAccess(context);
        this.subqueryParseTree.getQueryNode().qualifyAttributeAccess(context);
        if (this.subqueryParseTree.getWhereNode() != null) {
            this.subqueryParseTree.getWhereNode().qualifyAttributeAccess(context);
        }
        if (this.subqueryParseTree.getGroupByNode() != null) {
            this.subqueryParseTree.getGroupByNode().qualifyAttributeAccess(context);
        }
        if (this.subqueryParseTree.getHavingNode() != null) {
            this.subqueryParseTree.getHavingNode().qualifyAttributeAccess(context);
        }
        return this;
    }

    @Override
    public void validate(ParseTreeContext context) {
        this.subqueryParseTree.validate(context);
        this.outerVars = context.getOuterScopeVariables();
        SelectNode selectNode = (SelectNode)this.subqueryParseTree.getQueryNode();
        Node selectExpr = selectNode.getSelectExpressions().get(0);
        this.setType(selectExpr.getType());
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression base = context.getBaseExpression();
        ReportQuery innerQuery = this.getReportQuery(context);
        return base.subQuery(innerQuery);
    }

    @Override
    public boolean isSubqueryNode() {
        return true;
    }

    public void setParseTree(JPQLParseTree parseTree) {
        this.subqueryParseTree = parseTree;
    }

    public JPQLParseTree getParseTree() {
        return this.subqueryParseTree;
    }
}

