/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.util.InternalError;
import com.sun.jdo.api.persistence.enhancer.util.Support;

class FieldTypeInfo
extends Support
implements VMConstants {
    String fieldCreateMethod;
    String fieldCreateMethodSig;
    String fieldGetMethod;
    String fieldGetMethodSig;
    int fieldGetReturnType;
    String fieldSetMethod;
    String fieldSetMethodSig;
    int fieldSetArgType;
    private static FieldTypeInfo byteInfo = new FieldTypeInfo("createByte", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setByteField", "(IBLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 8, "getByteField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)B", 8);
    private static FieldTypeInfo charInfo = new FieldTypeInfo("createChar", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setCharField", "(ICLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 5, "getCharField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)C", 5);
    private static FieldTypeInfo shortInfo = new FieldTypeInfo("createShort", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setShortField", "(ISLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 9, "getShortField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)S", 9);
    private static FieldTypeInfo intInfo = new FieldTypeInfo("createInt", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setIntField", "(IILcom/sun/forte4j/persistence/internal/ClassInfo;)V", 10, "getIntField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)I", 10);
    private static FieldTypeInfo longInfo = new FieldTypeInfo("createLong", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setLongField", "(IJLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 11, "getLongField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)J", 11);
    private static FieldTypeInfo floatInfo = new FieldTypeInfo("createFloat", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setFloatField", "(IFLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 6, "getFloatField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)F", 6);
    private static FieldTypeInfo doubleInfo = new FieldTypeInfo("createDouble", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setDoubleField", "(IDLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 7, "getDoubleField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)D", 7);
    private static FieldTypeInfo booleanInfo = new FieldTypeInfo("createBoolean", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setBooleanField", "(IZLcom/sun/forte4j/persistence/internal/ClassInfo;)V", 4, "getBooleanField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Z", 4);
    private static FieldTypeInfo classInfo = new FieldTypeInfo("createClass", "(Ljava/lang/String;Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setClassField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getClassField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo stringInfo = new FieldTypeInfo("createString", "(Ljava/lang/String;)Lcom/sun/forte4j/persistence/internal/Field;", "setStringField", "(ILjava/lang/String;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 14, "getStringField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/String;", 14);
    private static FieldTypeInfo byteArrayInfo = new FieldTypeInfo("createByteArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo charArrayInfo = new FieldTypeInfo("createCharArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo shortArrayInfo = new FieldTypeInfo("createShortArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo intArrayInfo = new FieldTypeInfo("createIntArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo longArrayInfo = new FieldTypeInfo("createLongArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo floatArrayInfo = new FieldTypeInfo("createFloatArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo doubleArrayInfo = new FieldTypeInfo("createDoubleArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo booleanArrayInfo = new FieldTypeInfo("createBooleanArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo classArrayInfo = new FieldTypeInfo("createClassArray", "(Ljava/lang/String;Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo interfaceArrayInfo = new FieldTypeInfo("createInterfaceArray", "(Ljava/lang/String;Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);
    private static FieldTypeInfo stringArrayInfo = new FieldTypeInfo("createStringArray", "(Ljava/lang/String;I)Lcom/sun/forte4j/persistence/internal/Field;", "setArrayField", "(ILjava/lang/Object;Lcom/sun/forte4j/persistence/internal/ClassInfo;)V", 12, "getArrayField", "(ILcom/sun/forte4j/persistence/internal/ClassInfo;)Ljava/lang/Object;", 12);

    private FieldTypeInfo(String createName, String createSig, String setName, String setSig, int argType, String getName, String getSig, int returnType) {
        this.fieldCreateMethod = createName;
        this.fieldCreateMethodSig = createSig;
        this.fieldGetMethod = getName;
        this.fieldGetMethodSig = getSig;
        this.fieldGetReturnType = returnType;
        this.fieldSetMethod = setName;
        this.fieldSetMethodSig = setSig;
        this.fieldSetArgType = argType;
    }

    static FieldTypeInfo determineFieldType(String sig, Environment env) {
        switch (sig.charAt(0)) {
            case 'B': {
                return byteInfo;
            }
            case 'C': {
                return charInfo;
            }
            case 'D': {
                return doubleInfo;
            }
            case 'F': {
                return floatInfo;
            }
            case 'I': {
                return intInfo;
            }
            case 'J': {
                return longInfo;
            }
            case 'S': {
                return shortInfo;
            }
            case 'Z': {
                return booleanInfo;
            }
            case 'L': {
                if (sig.equals("Ljava/lang/String;")) {
                    return stringInfo;
                }
                return classInfo;
            }
            case '[': {
                int baseTypeIndex = FieldTypeInfo.findArrayBaseType(sig);
                switch (sig.charAt(baseTypeIndex)) {
                    case 'B': {
                        return byteArrayInfo;
                    }
                    case 'C': {
                        return charArrayInfo;
                    }
                    case 'D': {
                        return doubleArrayInfo;
                    }
                    case 'F': {
                        return floatArrayInfo;
                    }
                    case 'I': {
                        return intArrayInfo;
                    }
                    case 'J': {
                        return longArrayInfo;
                    }
                    case 'S': {
                        return shortArrayInfo;
                    }
                    case 'Z': {
                        return booleanArrayInfo;
                    }
                    case 'L': {
                        if (sig.substring(baseTypeIndex).equals("Ljava/lang/String;")) {
                            return stringArrayInfo;
                        }
                        return classArrayInfo;
                    }
                }
                throw new InternalError("Missing case");
            }
        }
        throw new InternalError("Missing case");
    }

    private static int findArrayBaseType(String sig) {
        int idx = 0;
        while (sig.charAt(idx) == '[') {
            ++idx;
        }
        return idx;
    }
}

