/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

final class FileLister {
    private static final System.Logger LOG = System.getLogger(FileLister.class.getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(FileLister.class);
    static final String ASTERISK = "*";

    FileLister() {
    }

    public List<File> getFiles(String pathPattern) {
        int asteriskIndex = pathPattern.indexOf(ASTERISK);
        if (asteriskIndex < 0) {
            return this.getAllChildFiles(new File(pathPattern));
        }
        LinkedList<File> retrievedFiles = new LinkedList<File>();
        for (int numTries = 0; numTries < 2; ++numTries) {
            WildCardFilenameFilter filter;
            String[] childFileNames;
            String head = pathPattern.substring(0, asteriskIndex);
            String tail = asteriskIndex < pathPattern.length() - 1 ? pathPattern.substring(asteriskIndex + 1) : "";
            File parent = new File(head + "temp").getParentFile();
            if (parent == null) {
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, _strings.get("parentFileNotSpecified"));
                }
                parent = new File(head + "temp").getAbsoluteFile().getParentFile();
            }
            String pattern = pathPattern;
            int nextSeparator = -1;
            if (tail.length() > 0) {
                nextSeparator = pathPattern.indexOf(File.separator, asteriskIndex + 1);
            }
            if (nextSeparator > asteriskIndex) {
                pattern = pathPattern.substring(0, nextSeparator);
            }
            if ((childFileNames = parent.list(filter = new WildCardFilenameFilter(pattern))) != null) {
                for (String childName : childFileNames) {
                    String path = parent.getAbsolutePath() + File.separator + childName;
                    File file = new File(path);
                    if (nextSeparator < asteriskIndex) {
                        if (!file.isFile()) continue;
                        retrievedFiles.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    if (nextSeparator == pathPattern.length() - 1) {
                        retrievedFiles.addAll(this.getAllChildFiles(file));
                        continue;
                    }
                    String newpattern = path + File.separator + pathPattern.substring(nextSeparator + 1);
                    retrievedFiles.addAll(this.getFiles(newpattern));
                }
            }
            if (!retrievedFiles.isEmpty() || !File.separator.equals("\\") || !pathPattern.contains("/")) break;
            pathPattern = pathPattern.replace("/", File.separator);
            LOG.log(System.Logger.Level.DEBUG, "detected \"/\" in pathWithPattern on Windows, replace with \"\\\"");
        }
        return retrievedFiles;
    }

    public List<File> getAllChildFiles(File rootfile) {
        LinkedList<File> retFiles = new LinkedList<File>();
        if (!rootfile.exists()) {
            LOG.log(System.Logger.Level.INFO, () -> "Could not locate file or resource " + rootfile.getAbsolutePath());
        } else if (!rootfile.isDirectory()) {
            retFiles.add(rootfile);
        } else {
            File[] files = rootfile.listFiles();
            if (files != null) {
                for (File file : files) {
                    retFiles.addAll(this.getAllChildFiles(file));
                }
            }
        }
        return retFiles;
    }

    private static class WildCardFilenameFilter
    implements FilenameFilter {
        private String _pattern;
        private boolean _endsWithWc;

        public WildCardFilenameFilter(String pattern) {
            this._pattern = pattern;
            this._endsWithWc = this._pattern.endsWith(FileLister.ASTERISK);
        }

        @Override
        public boolean accept(File dir, String name) {
            Object fullpath = String.valueOf(dir) + File.separator + name;
            StringTokenizer tokenizedPattern = new StringTokenizer(this._pattern, FileLister.ASTERISK);
            while (tokenizedPattern.hasMoreTokens()) {
                String subpattern = tokenizedPattern.nextToken();
                int start = ((String)fullpath).indexOf(subpattern);
                if (start < 0) {
                    return false;
                }
                fullpath = ((String)fullpath).substring(start + subpattern.length());
            }
            return ((String)fullpath).length() == 0 || this._endsWithWc;
        }
    }
}

