/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.LocalResourceImpl;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class SystemRepositoryImpl
implements Repository {
    private final Logger m_logger;
    private final long lastModified;
    private final LocalResourceImpl systemBundleResource;

    public SystemRepositoryImpl(BundleContext context, Logger logger) {
        this.m_logger = logger;
        this.lastModified = System.currentTimeMillis();
        try {
            this.systemBundleResource = new LocalResourceImpl(context.getBundle(0L));
        }
        catch (InvalidSyntaxException ex) {
            this.m_logger.log(2, ex.getMessage(), ex);
            throw new IllegalStateException("Unexpected error", ex);
        }
    }

    public String getURI() {
        return "system";
    }

    public Resource[] getResources() {
        return new Resource[]{this.systemBundleResource};
    }

    public String getName() {
        return "System Repository";
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

