/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.boot.osgi;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.main.boot.osgi.EmbeddedOSGiGlassFishRuntime;
import org.glassfish.main.boot.osgi.EmbeddedOSGiGlassFishRuntimeBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GlassFishMainActivator
implements BundleActivator {
    private static final System.Logger LOG = System.getLogger(GlassFishMainActivator.class.getName());
    private static final String[] DEFAULT_INSTALLATION_LOCATIONS_RELATIVE = new String[]{"modules/", "modules/autostart/"};
    private static final String[] DEFAULT_START_LOCATIONS_RELATIVE = new String[]{"modules/osgi-resource-locator.jar", "modules/osgi-adapter.jar", "modules/autostart/"};
    private GlassFishRuntime gfr;
    private GlassFish gf;
    private boolean embedded;
    private String installRoot;

    public void start(BundleContext context) throws Exception {
        this.embedded = context.getProperty("GlassFish.BUILDER_NAME") == null;
        LOG.log(System.Logger.Level.DEBUG, "Starting {0}; embedded: {1}", context.getBundle(), this.embedded);
        if (this.embedded) {
            this.startEmbedded(context);
        } else {
            this.startNonEmbedded(context);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (!this.embedded) {
            LOG.log(System.Logger.Level.DEBUG, "We are in non-embedded mode, so {0} has nothing to do.", context.getBundle());
            return;
        }
        try {
            if (this.gf != null && this.gf.getStatus() != GlassFish.Status.DISPOSED) {
                this.gf.dispose();
            }
        }
        finally {
            this.gf = null;
        }
        if (this.gfr != null) {
            this.gfr.shutdown();
            this.gfr = null;
        }
    }

    private void startNonEmbedded(BundleContext context) {
        EmbeddedOSGiGlassFishRuntime embeddedGfr = new EmbeddedOSGiGlassFishRuntime(context);
        context.registerService(GlassFishRuntime.class.getName(), (Object)embeddedGfr, null);
        LOG.log(System.Logger.Level.DEBUG, "Registered {0} in service registry.", new Object[]{embeddedGfr});
    }

    private void startEmbedded(BundleContext context) throws GlassFishException {
        Properties properties = this.prepareStartupContext(context);
        BootstrapProperties bsProperties = new BootstrapProperties(properties);
        System.out.println(String.valueOf(GlassFishRuntime.class) + " is loaded by [" + String.valueOf(GlassFishRuntime.class.getClassLoader()) + "]");
        GlassFishRuntime existingGfr = this.lookupGfr(context);
        if (existingGfr == null) {
            LOG.log(System.Logger.Level.DEBUG, "Bootstrapping a new GlassFishRuntime");
            existingGfr = this.gfr = GlassFishRuntime.bootstrap((BootstrapProperties)bsProperties, (ClassLoader)this.getClass().getClassLoader());
        } else {
            LOG.log(System.Logger.Level.DEBUG, "Starting existing GlassFishRuntime: [{0}]", existingGfr);
        }
        this.gf = existingGfr.newGlassFish(new GlassFishProperties(properties));
        this.gf.start();
    }

    private GlassFishRuntime lookupGfr(BundleContext context) {
        if (context == null) {
            return null;
        }
        ServiceReference serviceReference = context.getServiceReference(GlassFishRuntime.class);
        return serviceReference == null ? null : (GlassFishRuntime)context.getService(serviceReference);
    }

    private Properties prepareStartupContext(BundleContext context) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        for (String key : properties.stringPropertyNames()) {
            String value = context.getProperty(key);
            if (value == null || value.equals(System.getProperty(key))) continue;
            properties.setProperty(key, value);
        }
        this.installRoot = context.getProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName());
        properties.setProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName(), this.installRoot);
        String instanceRoot = context.getProperty(GlassFishVariable.INSTANCE_ROOT.getPropertyName());
        properties.setProperty(GlassFishVariable.INSTANCE_ROOT.getPropertyName(), instanceRoot);
        properties.putAll((Map<?, ?>)this.makeProvisioningOptions(context));
        properties.setProperty("GlassFish.BUILDER_NAME", EmbeddedOSGiGlassFishRuntimeBuilder.class.getName());
        return properties;
    }

    private Properties makeProvisioningOptions(BundleContext context) {
        Properties provisioningOptions = new Properties();
        URI installURI = new File(this.installRoot).toURI();
        String installLocations = context.getProperty("glassfish.osgi.auto.install");
        if (installLocations == null) {
            StringBuilder defaultInstallLocations = new StringBuilder();
            for (String entry : DEFAULT_INSTALLATION_LOCATIONS_RELATIVE) {
                defaultInstallLocations.append(installURI.resolve(entry)).append(' ');
            }
            installLocations = defaultInstallLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.install", installLocations);
        String startLocations = context.getProperty("glassfish.osgi.auto.start");
        if (startLocations == null) {
            StringBuilder defaultStartLocations = new StringBuilder();
            for (String entry : DEFAULT_START_LOCATIONS_RELATIVE) {
                defaultStartLocations.append(installURI.resolve(entry)).append(' ');
            }
            startLocations = defaultStartLocations.toString();
        }
        provisioningOptions.setProperty("glassfish.osgi.auto.start", startLocations);
        LOG.log(System.Logger.Level.DEBUG, "Provisioning options are {0}", provisioningOptions);
        return provisioningOptions;
    }
}

