/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.RuntimeFlowInSplitExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.status.SplitExecutionStatus;
import com.ibm.jbatch.container.util.BatchFlowInSplitWorkUnit;
import com.ibm.jbatch.container.util.BatchParallelWorkUnit;
import com.ibm.jbatch.container.util.FlowInSplitBuilderConfig;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobExecution jobExecution;
    private volatile List<BatchFlowInSplitWorkUnit> parallelBatchWorkUnits;
    private final ServicesManager servicesManager;
    private final IBatchKernelService batchKernel;
    private final JobContextImpl jobContext;
    private final BlockingQueue<BatchFlowInSplitWorkUnit> completedWorkQueue = new LinkedBlockingQueue<BatchFlowInSplitWorkUnit>();
    private final long rootJobExecutionId;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;
    private ExtendedBatchStatus aggregateStatus = null;

    public SplitControllerImpl(RuntimeJobExecution jobExecution, Split split, long rootJobExecutionId) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecutionId = rootJobExecutionId;
        this.split = split;
        this.servicesManager = ServicesManagerImpl.getInstance();
        this.batchKernel = this.servicesManager.getBatchKernelService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelBatchWorkUnits != null) {
                for (BatchParallelWorkUnit batchParallelWorkUnit : this.parallelBatchWorkUnits) {
                    long jobExecutionId = -1L;
                    try {
                        jobExecutionId = batchParallelWorkUnit.getJobExecutionImpl().getExecutionId();
                        this.batchKernel.stopJob(jobExecutionId);
                    }
                    catch (JobExecutionNotRunningException e) {
                        logger.fine("Caught exception trying to stop subjob: " + jobExecutionId + ", which was not running.");
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    @Override
    public SplitExecutionStatus execute() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod, "Root JobExecution Id = " + this.rootJobExecutionId);
        }
        this.buildSubJobBatchWorkUnits();
        this.executeWorkUnits();
        SplitExecutionStatus status = this.waitForCompletionAndAggregateStatus();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, sourceMethod, status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSubJobBatchWorkUnits() {
        List<Flow> flows = this.split.getFlows();
        this.parallelBatchWorkUnits = new ArrayList<BatchFlowInSplitWorkUnit>();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildFlowInSplitSubJob(this.jobContext, this.split, flow));
            }
            for (JSLJob job : this.subJobs) {
                int count = this.batchKernel.getJobInstanceCount(job.getId());
                FlowInSplitBuilderConfig config = new FlowInSplitBuilderConfig(job, this.completedWorkQueue, this.rootJobExecutionId);
                if (count == 0) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildNewFlowInSplitWorkUnit(config));
                    continue;
                }
                if (count == 1) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildOnRestartFlowInSplitWorkUnit(config));
                    continue;
                }
                throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
            }
        }
    }

    private void executeWorkUnits() {
        for (BatchParallelWorkUnit batchParallelWorkUnit : this.parallelBatchWorkUnits) {
            int count = this.batchKernel.getJobInstanceCount(batchParallelWorkUnit.getJobExecutionImpl().getJobInstance().getJobName());
            assert (count <= 1);
            if (count == 1) {
                this.batchKernel.startGeneratedJob(batchParallelWorkUnit);
                continue;
            }
            if (count > 1) {
                this.batchKernel.restartGeneratedJob(batchParallelWorkUnit);
                continue;
            }
            throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
        }
    }

    private SplitExecutionStatus waitForCompletionAndAggregateStatus() {
        SplitExecutionStatus splitStatus = new SplitExecutionStatus();
        for (int i = 0; i < this.subJobs.size(); ++i) {
            BatchFlowInSplitWorkUnit batchWork;
            try {
                batchWork = this.completedWorkQueue.take();
            }
            catch (InterruptedException e) {
                throw new BatchContainerRuntimeException(e);
            }
            RuntimeFlowInSplitExecution flowExecution = batchWork.getJobExecutionImpl();
            ExecutionStatus flowStatus = flowExecution.getFlowStatus();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob " + flowExecution.getExecutionId() + "ended with flow-in-split status: " + flowStatus);
            }
            this.aggregateTerminatingStatusFromSingleFlow(flowStatus, splitStatus);
        }
        if (this.aggregateStatus == null) {
            logger.fine("Setting normal split status as no contained flows ended the job.");
            this.aggregateStatus = ExtendedBatchStatus.NORMAL_COMPLETION;
        }
        splitStatus.setExtendedBatchStatus(this.aggregateStatus);
        logger.fine("Returning from waitForCompletionAndAggregateStatus with return value: " + splitStatus);
        return splitStatus;
    }

    private void aggregateTerminatingStatusFromSingleFlow(ExecutionStatus flowStatus, SplitExecutionStatus splitStatus) {
        String exitStatus = flowStatus.getExitStatus();
        String restartOn = flowStatus.getRestartOn();
        ExtendedBatchStatus flowBatchStatus = flowStatus.getExtendedBatchStatus();
        logger.fine("Aggregating possible terminating status for flow ending with status: " + flowStatus + ", restartOn = " + restartOn);
        if (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_STOP) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
            if (this.aggregateStatus == null) {
                logger.fine("A flow detected as ended because of a terminating condition: " + flowBatchStatus.name() + ". First flow detected in terminating state.  Setting exitStatus if non-null.");
                this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                this.aggregateStatus = flowBatchStatus;
            } else {
                splitStatus.setCouldMoreThanOneFlowHaveTerminatedJob(true);
                if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                    logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <end> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                    this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                    this.aggregateStatus = flowBatchStatus;
                } else if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_STOP)) {
                    if (!flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                        logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <stop> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                        this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                        this.aggregateStatus = flowBatchStatus;
                    } else {
                        logger.fine("End does not override stop.  The flow with <end> will effectively be ignored with respect to terminating the job.");
                    }
                } else if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || this.aggregateStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                    if (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                        logger.warning("Current flow's batch and exit status will take precedence over and override earlier one from <fail> transition element or exception thrown. Overriding, setting exit status if non-null and preparing to end job.");
                        this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                        this.aggregateStatus = flowBatchStatus;
                    } else {
                        logger.fine("End and stop do not override exception thrown or <fail>.   The flow with <end> or <stop> will effectively be ignored with respect to terminating the job.");
                    }
                }
            }
        } else {
            logger.fine("Flow completing normally without any terminating transition or exception thrown.");
        }
    }

    private void setInJobContext(ExtendedBatchStatus flowBatchStatus, String exitStatus, String restartOn) {
        if (exitStatus != null) {
            this.jobContext.setExitStatus(exitStatus);
        }
        if (ExtendedBatchStatus.JSL_STOP.equals((Object)flowBatchStatus) && restartOn != null) {
            this.jobContext.setRestartOn(restartOn);
        }
    }

    public List<BatchFlowInSplitWorkUnit> getParallelJobExecs() {
        return this.parallelBatchWorkUnits;
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        ArrayList<Long> stepExecIdList = new ArrayList<Long>();
        for (BatchFlowInSplitWorkUnit workUnit : this.parallelBatchWorkUnits) {
            List<Long> stepExecIds = workUnit.getController().getLastRunStepExecutions();
            if (stepExecIds == null) continue;
            stepExecIdList.addAll(stepExecIds);
        }
        return stepExecIdList;
    }
}

