/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.contexts.cache;

import java.util.LinkedList;
import java.util.List;
import org.jboss.weld.contexts.cache.RequestScopedItem;

public class RequestScopedCache {
    private static final ThreadLocal<List<RequestScopedItem>> CACHE = new ThreadLocal();

    private RequestScopedCache() {
    }

    public static boolean isActive() {
        return CACHE.get() != null;
    }

    private static void checkCacheForAdding(List<RequestScopedItem> cache) {
        if (cache == null) {
            throw new IllegalStateException("Unable to add request scoped cache item when request cache is not active");
        }
    }

    public static void addItem(RequestScopedItem item) {
        List<RequestScopedItem> cache = CACHE.get();
        RequestScopedCache.checkCacheForAdding(cache);
        cache.add(item);
    }

    public static boolean addItemIfActive(RequestScopedItem item) {
        List<RequestScopedItem> cache = CACHE.get();
        if (cache != null) {
            cache.add(item);
            return true;
        }
        return false;
    }

    public static boolean addItemIfActive(final ThreadLocal<?> item) {
        List<RequestScopedItem> cache = CACHE.get();
        if (cache != null) {
            cache.add(new RequestScopedItem(){

                @Override
                public void invalidate() {
                    item.remove();
                }
            });
            return true;
        }
        return false;
    }

    public static void beginRequest() {
        RequestScopedCache.endRequest();
        CACHE.set(new LinkedList());
    }

    public static void endRequest() {
        List<RequestScopedItem> result = CACHE.get();
        if (result != null) {
            CACHE.remove();
            for (RequestScopedItem item : result) {
                item.invalidate();
            }
        }
    }

    public static void invalidate() {
        if (RequestScopedCache.isActive()) {
            RequestScopedCache.endRequest();
            RequestScopedCache.beginRequest();
        }
    }
}

