/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.web.valve.GlassFishValve;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private StandardContext context = null;

    StandardContextValve() {
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (container instanceof StandardContext) {
            this.context = (StandardContext)container;
        }
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Wrapper wrapper = this.preInvoke(request, response);
        if (wrapper == null) {
            return 2;
        }
        if (wrapper.getPipeline().hasNonBasicValves() || wrapper.hasCustomPipeline()) {
            wrapper.getPipeline().invoke(request, response);
        } else {
            GlassFishValve basic = wrapper.getPipeline().getBasic();
            if (basic != null) {
                basic.invoke(request, response);
                basic.postInvoke(request, response);
            }
        }
        return 2;
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        Wrapper wrapper = this.preInvoke(request, response);
        if (wrapper == null) {
            return;
        }
        if (wrapper.getPipeline().hasNonBasicValves() || wrapper.hasCustomPipeline()) {
            wrapper.getPipeline().invoke(request, response);
        } else {
            GlassFishValve basic = wrapper.getPipeline().getBasic();
            if (basic != null) {
                basic.invoke(request, response);
                basic.postInvoke(request, response);
            }
        }
        this.postInvoke(request, response);
    }

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }

    private void notFound(HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String normalize(String path) {
        int idx;
        if (path == null) {
            return null;
        }
        Object rv = path;
        if (((String)rv).indexOf("//") == 0) {
            rv = ((String)rv).replace("//", "/");
        }
        if (((String)rv).indexOf("./") == 0) {
            rv = ((String)rv).replaceFirst("./", "/");
        }
        if (((String)rv).indexOf(92) >= 0) {
            rv = ((String)rv).replace('\\', '/');
        }
        while ((idx = ((String)rv).indexOf("/../")) >= 0) {
            if (idx == 0) {
                return null;
            }
            int index2 = ((String)rv).lastIndexOf(47, idx - 1);
            rv = ((String)rv).substring(0, index2) + ((String)rv).substring(idx + 3);
        }
        if (!((String)(rv = StandardContextValve.evaluateNormalizedPathWithSinglePoint((String)rv))).startsWith("/")) {
            rv = "/" + (String)rv;
        }
        return rv;
    }

    static String evaluateNormalizedPathWithSinglePoint(String path) {
        int idx;
        while ((idx = ((String)path).indexOf("/./")) >= 0) {
            path = ((String)path).substring(0, idx) + ((String)path).substring(idx + 2);
        }
        return path;
    }

    private Wrapper preInvoke(Request request, Response response) {
        Wrapper wrapper;
        String requestPath;
        HttpRequest hreq = (HttpRequest)request;
        if (request.getCheckRestrictedResources() && ((requestPath = StandardContextValve.normalize(hreq.getRequestPathMB().toString(Charsets.UTF8_CHARSET))) == null || requestPath.toUpperCase().startsWith("/META-INF/", 0) || requestPath.equalsIgnoreCase("/META-INF") || requestPath.toUpperCase().startsWith("/WEB-INF/", 0) || requestPath.equalsIgnoreCase("/WEB-INF"))) {
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        boolean reloaded = false;
        while (((StandardContext)this.container).getPaused()) {
            reloaded = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (reloaded && this.context.getLoader() != null && this.context.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
        }
        if ((wrapper = request.getWrapper()) == null) {
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        if (wrapper.isUnavailable() && (wrapper = (Wrapper)this.container.findChild(wrapper.getName())) == null) {
            this.notFound((HttpServletResponse)response.getResponse());
            return null;
        }
        return wrapper;
    }
}

