/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.krazo.cdi.Internal;

@ApplicationScoped
public class ConstraintViolationTranslator {
    private static final Logger log = Logger.getLogger(ConstraintViolationTranslator.class.getName());
    @Inject
    @Internal
    private ValidatorFactory validatorFactory;

    public String translate(ConstraintViolation<?> violation, Locale locale) {
        SimpleMessageInterpolatorContext context = new SimpleMessageInterpolatorContext(violation);
        MessageInterpolator interpolator = this.validatorFactory.getMessageInterpolator();
        return interpolator.interpolate(violation.getMessageTemplate(), (MessageInterpolator.Context)context, locale);
    }

    private static class SimpleMessageInterpolatorContext
    implements MessageInterpolator.Context {
        private final ConstraintViolation<?> violation;

        public SimpleMessageInterpolatorContext(ConstraintViolation<?> violation) {
            this.violation = violation;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.violation.getConstraintDescriptor();
        }

        public Object getValidatedValue() {
            return this.violation.getInvalidValue();
        }

        public <T> T unwrap(Class<T> type) {
            throw new UnsupportedOperationException();
        }
    }
}

