/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Tab;
import com.sun.webui.jsf.component.WebuiInput;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.ValueChangeEvent;
import java.util.Stack;

public final class TabSet
extends WebuiInput
implements NamingContainer {
    private MethodExpression actionListenerExpression;
    private boolean lastSelectedChildSaved = true;
    private boolean lastSelectedChildSavedSet = true;
    private boolean lite = false;
    private boolean liteSet = false;
    private boolean mini = false;
    private boolean miniSet = false;
    private String style = null;
    private String styleClass = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public TabSet() {
        this.setRendererType("com.sun.webui.jsf.TabSet");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TabSet";
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("selected")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("selected")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public boolean isRequired() {
        return super.isRequired();
    }

    @Override
    public MethodExpression getValidatorExpression() {
        return super.getValidatorExpression();
    }

    public Object getValue() {
        return super.getValue();
    }

    public MethodExpression getActionListenerExpression() {
        return this.actionListenerExpression;
    }

    public void setActionListenerExpression(MethodExpression newActionListenerExpression) {
        this.actionListenerExpression = newActionListenerExpression;
    }

    public boolean isLastSelectedChildSaved() {
        if (this.lastSelectedChildSavedSet) {
            return this.lastSelectedChildSaved;
        }
        ValueExpression vb = this.getValueExpression("lastSelectedChildSaved");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setLastSelectedChildSaved(boolean newLastSelectedChildSaved) {
        this.lastSelectedChildSaved = newLastSelectedChildSaved;
        this.lastSelectedChildSavedSet = true;
    }

    public boolean isLite() {
        if (this.liteSet) {
            return this.lite;
        }
        ValueExpression vb = this.getValueExpression("lite");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setLite(boolean newLite) {
        this.lite = newLite;
        this.liteSet = true;
    }

    public boolean isMini() {
        if (this.miniSet) {
            return this.mini;
        }
        ValueExpression vb = this.getValueExpression("mini");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMini(boolean newMini) {
        this.mini = newMini;
        this.miniSet = true;
    }

    public String getSelected() {
        return (String)this.getValue();
    }

    public void setSelected(String selected) {
        this.setValue(selected);
    }

    public Tab getSelectedTab() {
        if (this.getChildCount() == 0) {
            return null;
        }
        Stack<Tab> tabStack = new Stack<Tab>();
        for (UIComponent child : this.getChildren()) {
            if (!Tab.class.isAssignableFrom(child.getClass())) continue;
            tabStack.push((Tab)child);
        }
        String id = this.getSelected();
        if (id == null) {
            if (tabStack.isEmpty()) {
                return null;
            }
            return (Tab)tabStack.get(0);
        }
        Tab selectedTab = null;
        while (selectedTab == null && !tabStack.isEmpty()) {
            Tab tab = (Tab)tabStack.pop();
            if (id.equals(tab.getId())) {
                selectedTab = tab;
                continue;
            }
            if (tab.getTabChildCount() <= 0) continue;
            tabStack.addAll(tab.getTabChildren());
        }
        return selectedTab;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void validate(FacesContext context) {
        Object submittedValue;
        Tab selectedTab;
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        if (!this.isImmediate() && (selectedTab = this.getSelectedTab()) != null && selectedTab.getChildCount() > 0) {
            Stack componentStack = new Stack();
            componentStack.addAll(selectedTab.getChildren());
            while (this.isValid() && !componentStack.isEmpty()) {
                UIComponent component = (UIComponent)componentStack.pop();
                if (component instanceof EditableValueHolder && !((EditableValueHolder)component).isValid()) {
                    this.setValid(false);
                }
                if (component.getChildCount() <= 0) continue;
                componentStack.addAll(component.getChildren());
            }
        }
        if (this.isValid() && (submittedValue = this.getSubmittedValue()) != null) {
            Object previousValue = this.getValue();
            this.setValue(submittedValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previousValue, submittedValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previousValue, submittedValue));
            }
        }
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.actionListenerExpression = (MethodExpression)values[1];
        this.lastSelectedChildSaved = (Boolean)values[2];
        this.lastSelectedChildSavedSet = (Boolean)values[3];
        this.lite = (Boolean)values[4];
        this.liteSet = (Boolean)values[5];
        this.mini = (Boolean)values[6];
        this.miniSet = (Boolean)values[7];
        this.style = (String)values[8];
        this.styleClass = (String)values[9];
        this.visible = (Boolean)values[10];
        this.visibleSet = (Boolean)values[11];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.actionListenerExpression, this.lastSelectedChildSaved ? Boolean.TRUE : Boolean.FALSE, this.lastSelectedChildSavedSet ? Boolean.TRUE : Boolean.FALSE, this.lite ? Boolean.TRUE : Boolean.FALSE, this.liteSet ? Boolean.TRUE : Boolean.FALSE, this.mini ? Boolean.TRUE : Boolean.FALSE, this.miniSet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public Tab findChildTab(String tabId) {
        if (tabId == null) {
            return null;
        }
        for (UIComponent child : this.getChildren()) {
            Tab tab = TabSet.findChildTab((Tab)child, tabId);
            if (tab == null) continue;
            return tab;
        }
        return null;
    }

    public static Tab findChildTab(Tab tab, String tabId) {
        if (tab == null || tabId == null) {
            return null;
        }
        if (tabId.equals(tab.getId())) {
            return tab;
        }
        if (tab.getTabChildCount() == 0) {
            return null;
        }
        for (Tab child : tab.getTabChildren()) {
            Tab foundTab = TabSet.findChildTab(child, tabId);
            if (foundTab == null) continue;
            return foundTab;
        }
        return null;
    }
}

