/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cfg;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.cfg.ServerFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;

public class StartupContextCfg {
    private final OsgiPlatform platform;
    private final Properties properties;
    private final ServerFiles files;

    public StartupContextCfg(OsgiPlatform platform, ServerFiles files, Properties properties) {
        properties.setProperty("GlassFish_Platform", platform.name());
        this.platform = platform;
        this.properties = properties;
        this.files = files;
    }

    public OsgiPlatform getPlatform() {
        return this.platform;
    }

    public Path getInstallRoot() {
        return this.files.getInstallRoot();
    }

    public Path getInstanceRoot() {
        return this.files.getInstanceRoot();
    }

    public File getFileUnderInstallRoot(Path relativePath) {
        return this.files.getFileUnderInstallRoot(relativePath);
    }

    public File getFileUnderInstanceRoot(Path relativePath) {
        return this.files.getFileUnderInstanceRoot(relativePath);
    }

    public File getOsgiHome(String envKey, String sysPropsKey, Path defaultSubdir) {
        return this.files.getOsgiHome(envKey, sysPropsKey, defaultSubdir);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public boolean isPropertySet(String key) {
        return this.properties.containsKey(key);
    }

    public void setAll(Properties source) {
        this.properties.putAll((Map<?, ?>)source);
    }

    public Properties toProperties() {
        return this.properties;
    }
}

