/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.cluster.ssh.launcher.JavaSystemJschLogger;
import org.glassfish.cluster.ssh.launcher.RemoteSystemCapabilities;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;

public class SSHKeyInstaller {
    private static final System.Logger LOG = System.getLogger(SSHKeyInstaller.class.getName());
    private static final String AUTH_KEY_FILE = "authorized_keys";
    private static final int DEFAULT_TIMEOUT_MSEC = 120000;
    private static final String SSH_KEYGEN = "ssh-keygen";
    private final SSHLauncher ssh;

    public SSHKeyInstaller(SSHLauncher ssh) {
        this.ssh = ssh;
    }

    public void setupKey(String node, File pubKeyFile, boolean generateKey, String passwd) throws IOException {
        File keyFile = this.ssh.getKeyFile();
        String userName = this.ssh.getUserName();
        LOG.log(System.Logger.Level.DEBUG, () -> "Key = " + String.valueOf(keyFile));
        if (keyFile.exists()) {
            if (this.ssh.checkConnection()) {
                throw new IOException("SSH public key authentication is already configured for " + userName + "@" + node);
            }
        } else if (generateKey) {
            if (!this.generateKeyPair(keyFile)) {
                throw new IOException("SSH key pair generation failed. Please generate key manually.");
            }
        } else {
            throw new IOException("SSH key pair not present. Please generate a key pair manually or specify an existing one and re-run the command.");
        }
        if (passwd == null) {
            throw new IOException("SSH password is required for distributing the public key. You can specify the SSH password in a password file and pass it through --passwordfile option.");
        }
        try (SSHSession session = this.ssh.openSession(passwd);
             SFTPClient sftp = session.createSFTPClient();){
            SFTPPath remoteSshDir;
            this.setupSSHDir();
            File pubKey = pubKeyFile == null ? new File(keyFile.getParent(), keyFile.getName() + ".pub") : pubKeyFile;
            if (!pubKey.exists()) {
                throw new IOException("Public key file " + String.valueOf(pubKey) + " does not exist.");
            }
            try {
                remoteSshDir = sftp.getHome().resolve(".ssh");
            }
            catch (InvalidPathException e) {
                throw new SSHException("Could not resolve ssh home directory of the remote user.", e);
            }
            RemoteSystemCapabilities capabilities = this.ssh.getCapabilities();
            if (!sftp.exists(remoteSshDir)) {
                LOG.log(System.Logger.Level.DEBUG, () -> ".ssh does not exist");
                sftp.mkdirs(remoteSshDir);
                if (capabilities.isChmodSupported()) {
                    sftp.chmod(remoteSshDir, 448);
                }
            }
            SFTPPath remoteKeyTmp = remoteSshDir.resolve("key.tmp");
            sftp.put(pubKey, remoteKeyTmp);
            if (capabilities.isChmodSupported()) {
                sftp.chmod(remoteKeyTmp, 384);
            }
            SFTPPath authKeyFile = remoteSshDir.resolve(AUTH_KEY_FILE);
            String mergeCommand = "cat \"" + String.valueOf(remoteKeyTmp) + "\" >> \"" + String.valueOf(authKeyFile) + "\"";
            LOG.log(System.Logger.Level.DEBUG, () -> "mergeCommand = " + mergeCommand);
            if (session.exec(mergeCommand) != 0) {
                throw new IOException("Failed to propogate the public key " + String.valueOf(pubKey) + " to " + this.ssh.getHost());
            }
            LOG.log(System.Logger.Level.INFO, "Copied keyfile " + String.valueOf(pubKey) + " to " + userName + "@" + this.ssh.getHost());
            try {
                sftp.rm(remoteKeyTmp);
                LOG.log(System.Logger.Level.DEBUG, "Removed the temporary key file on remote host");
            }
            catch (SSHException e) {
                LOG.log(System.Logger.Level.WARNING, "Failed to remove the public key file key.tmp on remote host " + this.ssh.getHost());
            }
            if (capabilities.isChmodSupported()) {
                LOG.log(System.Logger.Level.INFO, "Fixing file permissions for home(755), .ssh(700) and authorized_keys file(600)");
                sftp.cd(sftp.getHome());
                sftp.chmod(remoteSshDir.getParent(), 493);
                sftp.chmod(remoteSshDir, 448);
                sftp.chmod(authKeyFile, 384);
            }
        }
    }

    private boolean generateKeyPair(File keyFile) throws IOException {
        int exit;
        File keygenCmd = this.findSSHKeygen();
        LOG.log(System.Logger.Level.DEBUG, () -> "Using " + String.valueOf(keygenCmd) + " to generate key pair");
        if (!this.setupSSHDir()) {
            throw new IOException("Failed to set proper permissions on .ssh directory");
        }
        StringBuilder log = new StringBuilder();
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(keygenCmd.getAbsolutePath());
        log.append(keygenCmd);
        cmdLine.add("-t");
        log.append(" ").append("-t");
        cmdLine.add("rsa");
        log.append(" ").append("rsa");
        cmdLine.add("-N");
        log.append(" ").append("-N");
        if (this.ssh.getKeyFilePassphrase() == null) {
            log.append(" ").append("\"\"");
            if (OS.isWindows()) {
                cmdLine.add("\"\"");
            } else {
                cmdLine.add("");
            }
        } else {
            cmdLine.add(this.ssh.getKeyFilePassphrase());
            log.append(" ").append(JavaSystemJschLogger.maskForLogging(this.ssh.getKeyFilePassphrase()));
        }
        cmdLine.add("-f");
        log.append(" ").append("-f");
        cmdLine.add(keyFile.getAbsolutePath());
        log.append(" ").append(keyFile);
        ProcessManager pm = new ProcessManager(cmdLine);
        LOG.log(System.Logger.Level.DEBUG, () -> "Command = " + String.valueOf(log));
        pm.setTimeoutMsec(120000);
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            LOG.log(System.Logger.Level.DEBUG, () -> "Error while executing ssh-keygen.", (Throwable)ex);
            exit = 1;
        }
        if (exit == 0) {
            LOG.log(System.Logger.Level.INFO, () -> String.valueOf(keygenCmd) + " successfully generated the identification " + String.valueOf(keyFile));
        } else {
            LOG.log(System.Logger.Level.WARNING, () -> String.valueOf(keygenCmd) + " failed. It produced standard error output:\n" + pm.getStderr() + "\n and standard output:\n" + pm.getStdout());
        }
        return exit == 0;
    }

    private boolean setupSSHDir() throws IOException {
        boolean ret = true;
        File f = new File(FileUtils.USER_HOME, ".ssh");
        if (!FileUtils.safeIsDirectory((File)f)) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create " + f.getPath());
            }
            LOG.log(System.Logger.Level.INFO, "Created directory {0}", f);
        }
        if (!f.setReadable(false, false) || !f.setReadable(true)) {
            ret = false;
        }
        if (!f.setWritable(false, false) || !f.setWritable(true)) {
            ret = false;
        }
        if (!f.setExecutable(false, false) || !f.setExecutable(true)) {
            ret = false;
        }
        LOG.log(System.Logger.Level.DEBUG, "Fixed the .ssh directory permissions to 0700");
        return ret;
    }

    private File findSSHKeygen() {
        ArrayList<String> paths = new ArrayList<String>(List.of("/usr/bin/", "/usr/local/bin/"));
        if (OS.isWindows()) {
            paths.add("C:/cygwin/bin/");
            String mks = System.getenv("ROOTDIR");
            if (mks != null) {
                paths.add(mks + "/bin/");
            }
        }
        LOG.log(System.Logger.Level.DEBUG, () -> "Paths = " + String.valueOf(paths));
        File exe = ProcessUtils.getExe((String)SSH_KEYGEN);
        if (exe != null) {
            return exe;
        }
        for (String path : paths) {
            File f = new File(path, SSH_KEYGEN);
            if (!f.canExecute()) continue;
            return f.getAbsoluteFile();
        }
        return new File(SSH_KEYGEN);
    }
}

