/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.logviewer.backend;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.hk2.api.ServiceLocator;

public class LogFilterForInstance {
    /*
     * Enabled aggressive exception aggregation
     */
    public File downloadGivenInstanceLogFile(ServiceLocator habitat, Server targetServer, Domain domain, String instanceName, String domainRoot, String logFileName, String instanceLogFileName) throws IOException {
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (!node.getType().equals("SSH")) {
            return null;
        }
        SSHLauncher sshL = new SSHLauncher(node);
        try (SSHSession session = sshL.openSession();){
            File file;
            block24: {
                SFTPClient sftpClient = session.createSFTPClient();
                try {
                    SftpATTRS sftpFileAttributes;
                    long fileSizeOnNode;
                    SFTPPath loggingFile;
                    File logFileDirectoryOnServer = this.makingDirectory(Path.of(domainRoot, "logs", instanceName));
                    boolean noFileFound = true;
                    SFTPPath loggingDir = this.getLoggingDirectoryForSSHNode(instanceLogFileName, node, sNode, instanceName);
                    try {
                        List instanceLogFileNames = sftpClient.ls(loggingDir, this::isAcceptable);
                        if (!instanceLogFileNames.isEmpty()) {
                            noFileFound = false;
                        }
                    }
                    catch (Exception e) {
                        noFileFound = true;
                    }
                    if (noFileFound) {
                        loggingDir = this.getLoggingDirectoryForSSHNodeWhenNoFilesFound(instanceLogFileName, node, sNode, instanceName);
                    }
                    if (!sftpClient.exists(loggingFile = loggingDir.resolve(logFileName))) {
                        loggingFile = loggingDir.resolve("server.log");
                    } else if (!sftpClient.exists(loggingFile)) {
                        loggingFile = SFTPPath.of((String)instanceLogFileName);
                    }
                    long instanceLogFileSize = 0L;
                    File instanceLogFile = logFileDirectoryOnServer.toPath().resolve((Path)loggingFile.getFileName()).toFile();
                    if (instanceLogFile.exists()) {
                        instanceLogFileSize = instanceLogFile.length();
                    }
                    if (instanceLogFileSize != (fileSizeOnNode = (sftpFileAttributes = sftpClient.stat(loggingFile)).getSize())) {
                        sftpClient.download(loggingFile, instanceLogFile.toPath());
                    }
                    file = instanceLogFile;
                    if (sftpClient == null) break block24;
                }
                catch (Throwable throwable) {
                    if (sftpClient != null) {
                        try {
                            sftpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sftpClient.close();
            }
            return file;
        }
        catch (SSHException ex) {
            throw new SSHException("Unable to download log file of instance " + instanceName + " from SSH Node " + node.getName() + ".", (Exception)((Object)ex));
        }
    }

    public void downloadAllInstanceLogFiles(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, Path tempDirectoryOnServer, String instanceLogFileDirectory) throws IOException {
        String sNode = targetServer.getNodeRef();
        Nodes nodes = domain.getNodes();
        Node node = nodes.getNode(sNode);
        if (!node.getType().equals("SSH")) {
            return;
        }
        try {
            List<String> allInstanceLogFileNames = this.getInstanceLogFileNames(habitat, targetServer, domain, logger, instanceName, instanceLogFileDirectory);
            boolean noFileFound = true;
            SFTPPath sourceDir = this.getLoggingDirectoryForSSHNode(instanceLogFileDirectory, node, sNode, instanceName);
            SSHLauncher sshL = new SSHLauncher(node);
            try (SSHSession session = sshL.openSession();
                 SFTPClient sftpClient = session.createSFTPClient();){
                try {
                    List instanceLogFileNames = sftpClient.ls(sourceDir, this::isAcceptable);
                    if (!instanceLogFileNames.isEmpty()) {
                        noFileFound = false;
                    }
                }
                catch (Exception e) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    sourceDir = this.getLoggingDirectoryForSSHNodeWhenNoFilesFound(instanceLogFileDirectory, node, sNode, instanceName);
                }
                for (String fileName : allInstanceLogFileNames) {
                    sftpClient.download(sourceDir.resolve(fileName), tempDirectoryOnServer.resolve(fileName));
                }
            }
        }
        catch (Exception e) {
            throw new SSHException("Unable to download log file of instance " + instanceName + " from SSH Node " + node.getName() + ".", e);
        }
    }

    public List<String> getInstanceLogFileNames(ServiceLocator habitat, Server targetServer, Domain domain, Logger logger, String instanceName, String instanceLogFileDetails) throws IOException {
        String sNode = targetServer.getNodeRef();
        Node node = domain.getNodes().getNode(sNode);
        ArrayList<String> instanceLogFileNamesAsString = new ArrayList<String>();
        if (node.isLocal()) {
            String fileName;
            Path loggingDir = this.getLoggingDirectoryForNode(instanceLogFileDetails, node, sNode, instanceName);
            File logsDir = loggingDir.toFile();
            File[] allLogFileNames = logsDir.listFiles();
            boolean noFileFound = true;
            if (allLogFileNames != null) {
                for (File file : allLogFileNames) {
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                    noFileFound = false;
                }
            }
            if (noFileFound) {
                loggingDir = this.getLoggingDirectoryForNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                logsDir = loggingDir.toFile();
                for (File file : allLogFileNames = logsDir.listFiles()) {
                    fileName = file.getName();
                    if (!file.isFile() || fileName.equals(".") || fileName.equals("..") || !fileName.contains(".log") || fileName.contains(".log.")) continue;
                    instanceLogFileNamesAsString.add(fileName);
                }
            }
        } else if (node.getType().equals("SSH")) {
            SSHLauncher sshL = new SSHLauncher(node);
            try (SSHSession session = sshL.openSession();
                 SFTPClient sftpClient = session.createSFTPClient();){
                List instanceLogFileNames;
                boolean noFileFound = true;
                SFTPPath loggingDir = this.getLoggingDirectoryForSSHNode(instanceLogFileDetails, node, sNode, instanceName);
                try {
                    instanceLogFileNames = sftpClient.ls(loggingDir, this::isAcceptable);
                    for (String file : instanceLogFileNames) {
                        instanceLogFileNamesAsString.add(file);
                        noFileFound = false;
                    }
                }
                catch (Exception ex) {
                    noFileFound = true;
                }
                if (noFileFound) {
                    loggingDir = this.getLoggingDirectoryForSSHNodeWhenNoFilesFound(instanceLogFileDetails, node, sNode, instanceName);
                    instanceLogFileNames = sftpClient.ls(loggingDir, this::isAcceptable);
                    instanceLogFileNamesAsString.addAll(instanceLogFileNames);
                }
            }
            catch (SSHException e) {
                throw new SSHException("Unable to download log file of instance " + instanceName + " from SSH Node " + node.getName() + ".", (Exception)((Object)e));
            }
        }
        return instanceLogFileNamesAsString;
    }

    private File makingDirectory(Path path) {
        File targetDir = path.toFile();
        if (targetDir.exists() && !targetDir.delete()) {
            return targetDir;
        }
        if (targetDir.mkdir()) {
            return targetDir;
        }
        return null;
    }

    public Path getLoggingDirectoryForNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        if (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null) {
            return new File(node.getNodeDir()).toPath().resolve(Path.of(sNode, instanceName, "logs"));
        }
        if (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null) {
            return new File(node.getInstallDir()).toPath().resolve(Path.of("glassfish", "nodes", sNode, instanceName, "logs"));
        }
        return new File(instanceLogFileDirectory).toPath();
    }

    public Path getLoggingDirectoryForNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        if (node.getNodeDir() != null) {
            return new File(node.getNodeDir()).toPath().resolve(Path.of(sNode, instanceName, "logs"));
        }
        if (node.getInstallDir() != null) {
            return new File(node.getInstallDir()).toPath().resolve(Path.of("glassfish", "nodes", sNode, instanceName, "logs"));
        }
        return new File(instanceLogFileDirectory).toPath();
    }

    public SFTPPath getLoggingDirectoryForSSHNode(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        if (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getNodeDir() != null) {
            return SFTPPath.of((String)node.getNodeDir()).resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{sNode, instanceName, "logs"}));
        }
        if (instanceLogFileDirectory.contains("${com.sun.aas.instanceRoot}/logs") && node.getInstallDir() != null) {
            return SFTPPath.of((String)node.getInstallDir()).resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{"glassfish", "nodes", sNode, instanceName, "logs"}));
        }
        return SFTPPath.of((String)instanceLogFileDirectory);
    }

    public SFTPPath getLoggingDirectoryForSSHNodeWhenNoFilesFound(String instanceLogFileDirectory, Node node, String sNode, String instanceName) {
        if (node.getNodeDir() != null) {
            return SFTPPath.of((String)node.getNodeDir()).resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{sNode, instanceName, "logs"}));
        }
        if (node.getInstallDir() != null) {
            return SFTPPath.of((String)node.getInstallDir()).resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{"glassfish", "nodes", sNode, instanceName, "logs"}));
        }
        return SFTPPath.of((String)instanceLogFileDirectory);
    }

    private boolean isAcceptable(ChannelSftp.LsEntry file) {
        if (file.getAttrs().isDir()) {
            return false;
        }
        String fileName = file.getFilename();
        return fileName.contains(".log") && !fileName.equals(".") && !fileName.equals("..") && !fileName.contains(".log.");
    }
}

