/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.connector;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.CarArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.server.connector.AppClientSniffer;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="car")
@Singleton
public class CarDetector
implements ArchiveDetector {
    private static final String CAR_DETECTOR_RANK_PROP = "glassfish.car.detector.rank";
    private static final int DEFAULT_CAR_DETECTOR_RANK = 500;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private AppClientSniffer sniffer;
    private ArchiveHandler archiveHandler;
    private static final Logger LOG = Logger.getLogger(CarDetector.class.getName());
    private static final String APPLICATION_CLIENT_XML = "META-INF/application-client.xml";
    private static final String SUN_APPLICATION_CLIENT_XML = "META-INF/sun-application-client.xml";
    private static final String GF_APPLICATION_CLIENT_XML = "META-INF/glassfish-application-client.xml";

    public int rank() {
        return Integer.getInteger(CAR_DETECTOR_RANK_PROP, 500);
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        try {
            if (archive.exists(APPLICATION_CLIENT_XML) || archive.exists(SUN_APPLICATION_CLIENT_XML) || archive.exists(GF_APPLICATION_CLIENT_XML)) {
                return true;
            }
            Manifest manifest = archive.getManifest();
            if (manifest != null && manifest.getMainAttributes().containsKey(Attributes.Name.MAIN_CLASS)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        CarDetector carDetector = this;
        synchronized (carDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, LOG);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = this.serviceLocator.getService(ArchiveHandler.class, "car", new Annotation[0]);
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return CarArchiveType.CAR_ARCHIVE;
    }
}

