/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class AntFilterReader
extends DataType {
    private String className;
    private final Vector<Parameter> parameters = new Vector();
    private Path classpath;

    public void setClassName(String className) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.className = className;
    }

    public String getClassName() {
        if (this.isReference()) {
            return ((AntFilterReader)this.getCheckedRef()).getClassName();
        }
        this.dieOnCircularReference();
        return this.className;
    }

    public void addParam(Parameter param) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.parameters.addElement(param);
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
        this.setChecked(false);
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        this.setChecked(false);
        return this.classpath.createPath();
    }

    public Path getClasspath() {
        if (this.isReference()) {
            ((AntFilterReader)this.getCheckedRef()).getClasspath();
        }
        this.dieOnCircularReference();
        return this.classpath;
    }

    public void setClasspathRef(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
    }

    public Parameter[] getParams() {
        if (this.isReference()) {
            ((AntFilterReader)this.getCheckedRef()).getParams();
        }
        this.dieOnCircularReference();
        Object[] params = new Parameter[this.parameters.size()];
        this.parameters.copyInto(params);
        return params;
    }

    @Override
    public void setRefid(Reference r) throws BuildException {
        if (!this.parameters.isEmpty() || this.className != null || this.classpath != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    @Override
    protected synchronized void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            if (this.classpath != null) {
                AntFilterReader.pushAndInvokeCircularReferenceCheck(this.classpath, stk, p);
            }
            this.setChecked(true);
        }
    }
}

