/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class GetInstancesFromServiceLoader {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private GetInstancesFromServiceLoader() {
    }

    public static <T> List<T> action(ClassLoader primaryClassLoader, Class<T> serviceClass) {
        List<T> instances = GetInstancesFromServiceLoader.loadInstances(primaryClassLoader, serviceClass);
        if (instances.isEmpty() && GetInstancesFromServiceLoader.class.getClassLoader() != primaryClassLoader) {
            instances = GetInstancesFromServiceLoader.loadInstances(GetInstancesFromServiceLoader.class.getClassLoader(), serviceClass);
        }
        return instances;
    }

    private static <T> List<T> loadInstances(ClassLoader classloader, Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz, classloader);
        Iterator<T> iterator = loader.iterator();
        ArrayList<T> instances = new ArrayList<T>();
        while (iterator.hasNext()) {
            try {
                instances.add(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                LOG.unableToLoadInstanceOfService(loader.getClass().getName(), e);
            }
        }
        return instances;
    }
}

