/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.listener;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.api.LogManager;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.resourcebase.resources.ResourceTypeOrderProcessor;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceDeployerValidator;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourcesBinder;
import org.glassfish.resourcebase.resources.listener.ResourceManagerLifecycleListener;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@RunLevel(value=2, mode=0)
@Service(name="ResourceManager")
public class ResourceManager
implements PostConstruct,
PreDestroy,
ConfigListener {
    @LogMessagesResourceBundle
    public static final String LOGMESSAGE_RESOURCE = "org.glassfish.resourcebase.resources.LogMessages";
    @LoggerInfo(subsystem="RESOURCE", description="Nucleus Resource", publish=true)
    public static final String LOGGER = "jakarta.enterprise.resources.listener";
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.resources.listener", "org.glassfish.resourcebase.resources.LogMessages");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceManager.class);
    @Inject
    @Optional
    private LogManager dependency0;
    @Inject
    private ServiceLocator locator;
    @Inject
    private ResourcesBinder resourcesBinder;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private IterableProvider<ResourceManagerLifecycleListener> resourceManagerLifecycleListenerProviders;
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private Domain domain;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ResourceTypeOrderProcessor resourceTypeOrderProcessor;

    public void postConstruct() {
        this.notifyListeners(ResourceManagerLifecycleListener.EVENT.STARTUP);
        this.deployResources(this.resourceTypeOrderProcessor.getOrderedResources(this.domain.getResources().getResources()));
        this.addListenerToResources();
        this.addListenerToResourceRefs();
        this.addListenerToServer();
    }

    private void notifyListeners(ResourceManagerLifecycleListener.EVENT event) {
        for (ResourceManagerLifecycleListener listener : this.resourceManagerLifecycleListenerProviders) {
            listener.resourceManagerLifecycleEvent(event);
        }
    }

    private void addListenerToResources() {
        Resources resources = this.domain.getResources();
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)resources);
        bean.addListener((ConfigListener)this);
    }

    private void addListenerToServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.addListener((ConfigListener)this);
        Config config = server.getConfig();
        if (config != null) {
            ((ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)config)).addListener((ConfigListener)this);
        }
    }

    private Server getServerBean() {
        return this.domain.getServerNamed(this.environment.getInstanceName());
    }

    public void deployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            if (resource instanceof BindableResource) {
                BindableResource bindableResource = (BindableResource)resource;
                if (!this.bindableResourcesHelper.isBindableResourceEnabled(bindableResource)) continue;
                SimpleJndiName jndiName = SimpleJndiName.of((String)bindableResource.getJndiName());
                ResourceInfo resourceInfo = new ResourceInfo(jndiName);
                this.resourcesBinder.deployResource(resourceInfo, resource);
                continue;
            }
            if (resource instanceof ServerResource) {
                this.deployServerResource(resource);
                continue;
            }
            if (resource instanceof ResourcePool) continue;
            try {
                ResourceDeployer<Resource> deployer = this.getResourceDeployer(resource);
                if (deployer == null) continue;
                deployer.deployResource(resource);
            }
            catch (Exception e) {
                Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
                logger.log(Level.WARNING, "NCLS-RESOURCE-00004", params);
            }
        }
        this.addListenerToResources(resources);
    }

    public Resources getAllResources() {
        return this.domain.getResources();
    }

    public void preDestroy() {
        this.removeListenerForAllResources();
        this.removeListenerForResources();
        this.removeListenerForResourceRefs();
        this.removeListenerForServer();
        this.notifyListeners(ResourceManagerLifecycleListener.EVENT.SHUTDOWN);
    }

    private void removeListenerForServer() {
        Server server = this.domain.getServerNamed(this.environment.getInstanceName());
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)server);
        bean.removeListener((ConfigListener)this);
        Config config = server.getConfig();
        if (config != null) {
            ((ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)config)).removeListener((ConfigListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            Object[] params;
            try {
                ResourceDeployer<Resource> deployer = this.getResourceDeployer(resource);
                if (deployer != null) {
                    deployer.undeployResource(resource);
                    continue;
                }
                params = new Object[]{resource.getIdentity()};
                logger.log(Level.WARNING, "NCLS-RESOURCE-00005", params);
            }
            catch (Exception e) {
                params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
                logger.log(Level.WARNING, "NCLS-RESOURCE-00006", params);
            }
            finally {
                this.removeListenerForResource(resource);
            }
        }
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(events), (Logger)logger);
    }

    private void addListenerToResources(Collection<Resource> resources) {
        for (Resource configuredResource : resources) {
            this.addListenerToResource(configuredResource);
        }
    }

    private boolean getEnabledResourceRefforResource(BindableResource bindableResource) {
        for (ResourceRef ref : this.getResourceRefs()) {
            if (!ref.getRef().equals(bindableResource.getJndiName())) continue;
            return Boolean.valueOf(ref.getEnabled());
        }
        return false;
    }

    private void addListenerToResourceRefs() {
        for (ResourceRef ref : this.getResourceRefs()) {
            this.addListenerToResource(ref);
        }
    }

    private List<ResourceRef> getResourceRefs() {
        Server server = this.getServerBean();
        ArrayList<ResourceRef> resourceRefs = new ArrayList<ResourceRef>(server.getResourceRef());
        Config config = server.getConfig();
        if (config != null) {
            resourceRefs.addAll(config.getResourceRef());
        }
        return resourceRefs;
    }

    private void addListenerToResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.addListener((ConfigListener)this);
        }
    }

    private void removeListenerForResource(Object instance) {
        ObservableBean bean = null;
        if (instance instanceof Resource) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        } else if (instance instanceof ResourceRef) {
            bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)((ConfigBeanProxy)instance));
            bean.removeListener((ConfigListener)this);
        }
    }

    private void removeListenerForResourceRefs() {
        for (ResourceRef ref : this.getResourceRefs()) {
            this.removeListenerForResource(ref);
        }
    }

    private void removeListenerForResources() {
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.domain.getResources());
        bean.removeListener((ConfigListener)this);
    }

    private void removeListenerForAllResources() {
        for (Resource configuredResource : this.domain.getResources().getResources()) {
            this.removeListenerForResource(configuredResource);
        }
    }

    private <T extends ConfigBeanProxy> ResourceDeployer<T> getResourceDeployer(T resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private boolean isServerResourceEnabled(Resource res) {
        ResourceDeployer<Resource> deployer = this.getResourceDeployer(res);
        return this.isServerResourceEnabled(res, deployer);
    }

    private boolean isServerResourceEnabled(Resource res, ResourceDeployer<Resource> deployer) {
        ResourceDeployerValidator deployerValidator;
        return res instanceof ServerResource && deployer != null && (deployerValidator = this.getResourceDeployerValidator(deployer)) != null && deployerValidator.isEnabledLocally(res);
    }

    private boolean isServerResourceDeployed(Resource resource) {
        ResourceDeployerValidator deployerValidator;
        ResourceDeployer<Resource> deployer = this.getResourceDeployer(resource);
        return resource instanceof ServerResource && deployer != null && (deployerValidator = this.getResourceDeployerValidator(deployer)) != null && deployerValidator.isDeployedLocally(resource);
    }

    private void deployServerResource(Resource resource) {
        ResourceDeployer<Resource> deployer = this.getResourceDeployer(resource);
        if (deployer == null) {
            logger.log(Level.WARNING, "NCLS-RESOURCE-00009", new Object[]{resource.getIdentity()});
            return;
        }
        try {
            if (this.isServerResourceEnabled(resource, deployer)) {
                deployer.deployResource(resource);
            } else if (this.isServerResourceDeployed(resource)) {
                deployer.undeployResource(resource);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
            logger.log(Level.WARNING, "NCLS-RESOURCE-00004", params);
        }
    }

    private void undeployServerResource(Resource resource) {
        ResourceDeployer<Resource> deployer = this.getResourceDeployer(resource);
        if (deployer == null) {
            logger.log(Level.WARNING, "NCLS-RESOURCE-00009", new Object[]{resource.getIdentity()});
            return;
        }
        try {
            ResourceDeployerValidator validator = this.getResourceDeployerValidator(deployer);
            if (validator != null) {
                boolean enabledLocally = validator.isEnabledLocally(resource);
                boolean deployed = validator.isDeployedLocally(resource);
                if (deployed && !enabledLocally) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Undeploy resource " + resource.getIdentity());
                    }
                    deployer.undeployResource(resource);
                } else if (enabledLocally) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Deploy resource " + resource.getIdentity());
                    }
                    deployer.deployResource(resource);
                }
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo(resource), e};
            logger.log(Level.WARNING, "NCLS-RESOURCE-00004", params);
        }
    }

    private void redeployResource(Resource resource) throws Exception {
        ResourceDeployer<Resource> resourceDeployer = this.getResourceDeployer(resource);
        if (resourceDeployer != null) {
            ResourceDeployerValidator validator = this.getResourceDeployerValidator(resourceDeployer);
            if (validator == null) {
                resourceDeployer.redeployResource(resource);
            } else if (validator.isEnabledLocally(resource)) {
                resourceDeployer.redeployResource(resource);
            } else if (validator.isDeployedLocally(resource)) {
                resourceDeployer.undeployResource(resource);
            }
        }
    }

    private ResourceDeployerValidator getResourceDeployerValidator(ResourceDeployer deployer) {
        ResourceDeployerInfo annotation = deployer.getClass().getAnnotation(ResourceDeployerInfo.class);
        ResourceDeployerValidator deployerValidator = (ResourceDeployerValidator)this.locator.getService(annotation.validator(), new Annotation[0]);
        return deployerValidator;
    }

    class PropertyChangeHandler
    implements Changed {
        PropertyChangeEvent[] events;

        private PropertyChangeHandler(PropertyChangeEvent[] events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            try {
                DelegatingClassLoader ccl = ResourceManager.this.clh.getConnectorClassLoader(null);
                Thread.currentThread().setContextClassLoader((ClassLoader)ccl);
                switch (type) {
                    case ADD: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A new " + changedType.getName() + " was added : " + String.valueOf(changedInstance));
                        }
                        np = this.handleAddEvent(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A " + changedType.getName() + " was changed : " + String.valueOf(changedInstance));
                        }
                        np = this.handleChangeEvent(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A " + changedType.getName() + " was removed : " + String.valueOf(changedInstance));
                        }
                        np = this.handleRemoveEvent(changedInstance);
                        break;
                    }
                    default: {
                        np = new NotProcessed("Unrecognized type of change: " + String.valueOf(type));
                    }
                }
                NotProcessed notProcessed = np;
                return notProcessed;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            NotProcessed np = null;
            try {
                if (ResourceUtil.isValidEventType(instance)) {
                    ResourceDeployer<T> deployer = ResourceManager.this.getResourceDeployer(instance);
                    boolean enabledAttributeChange = false;
                    if (instance instanceof BindableResource || instance instanceof ServerResource) {
                        Resource resource = (Resource)instance;
                        for (PropertyChangeEvent event : this.events) {
                            String propertyName = event.getPropertyName();
                            if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                            enabledAttributeChange = true;
                            if (deployer == null) continue;
                            boolean newValue = Boolean.valueOf(event.getNewValue().toString());
                            boolean oldValue = Boolean.valueOf(event.getOldValue().toString());
                            if (newValue && oldValue) continue;
                            if (resource instanceof ServerResource) {
                                if (!ResourceManager.this.isServerResourceEnabled(resource)) {
                                    deployer.disableResource((T)resource);
                                    continue;
                                }
                                deployer.enableResource((T)resource);
                                continue;
                            }
                            if (!(resource instanceof BindableResource)) continue;
                            if (newValue) {
                                deployer.enableResource((T)resource);
                                continue;
                            }
                            deployer.disableResource((T)resource);
                        }
                    }
                    if (!enabledAttributeChange && deployer != null) {
                        if (instance instanceof BindableResource) {
                            BindableResource bindableResource = (BindableResource)instance;
                            if (ResourceManager.this.getEnabledResourceRefforResource(bindableResource) && Boolean.parseBoolean(bindableResource.getEnabled())) {
                                deployer.redeployResource((T)bindableResource);
                            }
                        } else if (instance instanceof ServerResource) {
                            ResourceManager.this.redeployResource((Resource)((ServerResource)instance));
                        } else {
                            deployer.redeployResource(instance);
                        }
                    }
                } else if (ResourceUtil.isValidEventType(instance.getParent())) {
                    if (instance.getParent() instanceof BindableResource) {
                        ResourceDeployer<ConfigBeanProxy> parentDeployer;
                        BindableResource bindableResource = (BindableResource)instance.getParent();
                        if (ResourceManager.this.getEnabledResourceRefforResource(bindableResource) && Boolean.parseBoolean(bindableResource.getEnabled()) && (parentDeployer = ResourceManager.this.getResourceDeployer(instance.getParent())) != null) {
                            parentDeployer.redeployResource(instance.getParent());
                        }
                    } else if (instance instanceof ServerResource) {
                        ResourceManager.this.redeployResource((Resource)instance);
                    } else {
                        ResourceDeployer<ConfigBeanProxy> parentDeployer = ResourceManager.this.getResourceDeployer(instance.getParent());
                        if (parentDeployer != null) {
                            parentDeployer.redeployResource(instance.getParent());
                        }
                    }
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    String refName = ref.getRef();
                    Resource resource = ResourceUtil.getResourceByName(Resource.class, ResourceManager.this.domain.getResources(), refName);
                    ResourceDeployer<Resource> deployer = ResourceManager.this.getResourceDeployer(resource);
                    if (deployer != null) {
                        for (PropertyChangeEvent event : this.events) {
                            String propertyName = event.getPropertyName();
                            if (!"enabled".equalsIgnoreCase(propertyName)) continue;
                            if (resource instanceof ServerResource) {
                                if (!ResourceManager.this.isServerResourceEnabled(resource)) {
                                    deployer.disableResource(resource);
                                    continue;
                                }
                                deployer.enableResource(resource);
                                continue;
                            }
                            boolean newValue = Boolean.parseBoolean(event.getNewValue().toString());
                            boolean oldValue = Boolean.parseBoolean(event.getOldValue().toString());
                            if (newValue && oldValue) continue;
                            if (newValue) {
                                deployer.enableResource(resource);
                                continue;
                            }
                            deployer.disableResource(resource);
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "NCLS-RESOURCE-00007", ex);
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.change-event-failed", "Change event failed"));
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleAddEvent(T instance) {
            NotProcessed np = null;
            ResourceManager.this.addListenerToResource(instance);
            if (!(instance instanceof BindableResource || instance instanceof ServerResource || instance instanceof ResourcePool)) {
                if (instance instanceof Resource) {
                    try {
                        ResourceDeployer<T> deployer = ResourceManager.this.getResourceDeployer(instance);
                        if (deployer != null) {
                            deployer.deployResource(instance);
                        }
                    }
                    catch (Exception e) {
                        Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo((Resource)instance), e};
                        logger.log(Level.WARNING, "NCLS-RESOURCE-00004", params);
                    }
                } else if (!(instance instanceof Property) && instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    Resource resource = ResourceUtil.getResourceByIdentity(ResourceManager.this.domain.getResources(), ref.getRef());
                    if (resource instanceof BindableResource) {
                        BindableResource br = (BindableResource)resource;
                        if (Boolean.parseBoolean(ref.getEnabled()) && Boolean.parseBoolean(br.getEnabled())) {
                            SimpleJndiName jndiName = SimpleJndiName.of((String)br.getJndiName());
                            ResourceInfo resourceInfo = new ResourceInfo(jndiName);
                            ResourceManager.this.resourcesBinder.deployResource(resourceInfo, (Resource)br);
                        }
                    } else if (resource instanceof ServerResource) {
                        try {
                            ResourceManager.this.deployServerResource(resource);
                        }
                        catch (Exception e) {
                            Object[] params = new Object[]{ResourceUtil.getGenericResourceInfo((Resource)instance), e};
                            logger.log(Level.WARNING, "NCLS-RESOURCE-00004", params);
                        }
                    }
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleRemoveEvent(T instance) {
            NotProcessed np = null;
            try {
                if (instance instanceof BindableResource || instance instanceof ServerResource) {
                    ResourceManager.this.removeListenerForResource(instance);
                } else if (instance instanceof Resource) {
                    ResourceManager.this.removeListenerForResource(instance);
                    ResourceDeployer<T> resourceDeployer = ResourceManager.this.getResourceDeployer(instance);
                    if (resourceDeployer != null) {
                        resourceDeployer.undeployResource(instance);
                    }
                } else if (ResourceUtil.isValidEventType(instance.getParent())) {
                    if (instance.getParent() instanceof BindableResource) {
                        ResourceDeployer<ConfigBeanProxy> parentDeployer;
                        BindableResource bindableResource = (BindableResource)instance.getParent();
                        if (ResourceManager.this.getEnabledResourceRefforResource(bindableResource) && Boolean.valueOf(bindableResource.getEnabled()).booleanValue() && (parentDeployer = ResourceManager.this.getResourceDeployer(instance.getParent())) != null) {
                            parentDeployer.redeployResource(instance.getParent());
                        }
                    } else {
                        ResourceManager.this.redeployResource((Resource)instance.getParent());
                    }
                } else if (instance instanceof ResourceRef) {
                    ResourceRef ref = (ResourceRef)instance;
                    Resource resource = ResourceUtil.getResourceByName(Resource.class, ResourceManager.this.domain.getResources(), ref.getRef());
                    if (resource instanceof BindableResource) {
                        ResourceDeployer<Resource> resourceDeployer;
                        boolean resourceEnabled = this.isResourceEnabled(resource);
                        if (resourceEnabled && Boolean.valueOf(ref.getEnabled()).booleanValue() && (resourceDeployer = ResourceManager.this.getResourceDeployer(resource)) != null) {
                            resourceDeployer.undeployResource(resource);
                        }
                    } else if (resource instanceof ServerResource) {
                        ResourceManager.this.undeployServerResource(resource);
                    }
                    ResourceManager.this.removeListenerForResource(instance);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "NCLS-RESOURCE-00008", ex);
                np = new NotProcessed(localStrings.getLocalString("resources.resource-manager.remove-event-failed", "Remove event failed"));
            }
            return np;
        }

        private boolean isResourceEnabled(Resource resource) {
            boolean resourceEnabled = resource instanceof BindableResource ? Boolean.parseBoolean(((BindableResource)resource).getEnabled()) : ResourceManager.this.isServerResourceEnabled(resource);
            return resourceEnabled;
        }
    }
}

