/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.concurrent.admin.ManagedThreadFactoryManager;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-managed-thread-factory")
@PerLookup
@I18n(value="create.managed.thread.factory")
public class CreateManagedThreadFactory
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateManagedThreadFactory.class);
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Param(optional=true, defaultValue="true")
    private Boolean enabled;
    @Param(name="contextinfoenabled", alias="contextInfoEnabled", defaultValue="true", optional=true)
    private Boolean contextinfoenabled;
    @Param(name="contextinfo", alias="contextInfo", defaultValue="Classloader,JNDI,Security,WorkArea", optional=true)
    private String contextinfo;
    @Param(name="threadpriority", alias="threadPriority", defaultValue="5", optional=true)
    private Integer threadpriority;
    @Param(name="usevirtualthreads", alias="useVirtualThreads", defaultValue="false", optional=true)
    protected Boolean useVirtualThreads;
    @Param(optional=true)
    private String description;
    @Param(name="property", optional=true, separator=58)
    private Properties properties;
    @Param(optional=true)
    private String target = "server";
    @Inject
    private Domain domain;
    @Inject
    private ManagedThreadFactoryManager managedThreadFactoryMgr;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("jndi-name", this.jndiName);
        attrList.put("context-info-enabled", this.contextinfoenabled.toString());
        attrList.put("context-info", this.contextinfo);
        attrList.put("thread-priority", this.threadpriority.toString());
        attrList.put("use-virtual-threads", this.useVirtualThreads.toString());
        attrList.put("description", this.description);
        attrList.put("enabled", this.enabled.toString());
        try {
            rs = this.managedThreadFactoryMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.managed.thread.factory.failed", "Managed thread factory {0} creation failed", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

