/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.PersistenceManagerFactoryResource;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.jdbc.config.JdbcResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class PersistenceManagerFactoryResourceMigrator
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Resources resources;

    public void postConstruct() {
        Collection pmfResources = this.resources.getResources(PersistenceManagerFactoryResource.class);
        for (final PersistenceManagerFactoryResource pmfResource : pmfResources) {
            SimpleJndiName jdbcResourceName = SimpleJndiName.of((String)pmfResource.getJdbcResourceJndiName());
            final JdbcResource jdbcResource = (JdbcResource)this.resources.getResourceByName(JdbcResource.class, jdbcResourceName);
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources resources) throws PropertyVetoException, TransactionFailure {
                        resources.getResources().remove(pmfResource);
                        JdbcResource newResource = (JdbcResource)resources.createChild(JdbcResource.class);
                        newResource.setJndiName(pmfResource.getJndiName());
                        newResource.setDescription("Created to migrate persistence-manager-factory-resource from V2 domain");
                        newResource.setPoolName(jdbcResource.getPoolName());
                        newResource.setEnabled("true");
                        resources.getResources().add(newResource);
                        return newResource;
                    }
                }, (ConfigBeanProxy)this.resources);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading persistence-manager-factory-resource", tf);
                throw new RuntimeException(tf);
            }
        }
    }
}

