/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCO;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ForeignFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sco.SqlTimestamp;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;

public abstract class FieldDesc
implements Serializable {
    public static final int GROUP_DEFAULT = 1;
    public static final int GROUP_NONE = 0;
    public static final int PROP_IN_CONCURRENCY_CHECK = 1;
    public static final int PROP_LOG_ON_UPDATE = 2;
    public static final int PROP_READ_ONLY = 4;
    public static final int PROP_RECORD_ON_UPDATE = 8;
    public static final int PROP_REF_INTEGRITY_UPDATES = 16;
    public static final int PROP_PRIMARY_TRACKED_FIELD = 32;
    public static final int PROP_SECONDARY_TRACKED_FIELD = 64;
    public static final int PROP_TRACK_RELATIONSHIP_FIELD = 128;
    public static final int PROP_PRIMARY_KEY_FIELD = 256;
    public static final int PROP_VERSION_FIELD = 512;
    public static final int PROP_FOREIGN_KEY_FIELD = 1024;
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(String.valueOf(Long.MIN_VALUE));
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(String.valueOf(Long.MAX_VALUE));
    public int absoluteID;
    public int fetchGroup;
    public int concurrencyGroup;
    public int sqlProperties;
    private Field field;
    private Class fieldType;
    private int enumFieldType;
    private String fieldName;
    private Class declaringClass;
    private Class componentType;
    private ArrayList trackedFields;
    protected final ClassDesc classDesc;
    protected static final Logger logger = LogHelperSQLStore.getLogger();
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", FieldDesc.class.getClassLoader());

    FieldDesc(ClassDesc classDesc) {
        this.sqlProperties |= 0x10;
        this.sqlProperties |= 1;
        this.sqlProperties |= 2;
        this.concurrencyGroup = -1;
        this.classDesc = classDesc;
    }

    public String toString() {
        return this.classDesc.getName() + "." + this.getName();
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class getType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        return Object.class;
    }

    public int getEnumType() {
        return this.enumFieldType;
    }

    public String getName() {
        if (this.fieldName == null) {
            this.fieldName = "hidden" + -this.absoluteID;
        }
        return this.fieldName;
    }

    public Object getValue(StateManager sm) {
        if (sm == null) {
            return null;
        }
        if (this.absoluteID >= 0) {
            return ((PersistenceCapable)sm.getPersistent()).jdoGetField(this.absoluteID);
        }
        return sm.getHiddenValue(this.absoluteID);
    }

    public void setValue(StateManager sm, Object value) {
        boolean debug = logger.isLoggable(300);
        if (sm == null) {
            return;
        }
        if (this.absoluteID >= 0) {
            if (debug) {
                if (value != null && (value instanceof com.sun.jdo.api.persistence.support.PersistenceCapable || value instanceof Collection)) {
                    Object[] items = new Object[]{this.field.getName(), value.getClass()};
                    logger.finest("sqlstore.model.fielddesc.fieldname", items);
                } else {
                    Object[] items = new Object[]{this.field.getName(), value};
                    logger.finest("sqlstore.model.fielddesc.fieldname", items);
                }
            }
            if (value == null) {
                switch (this.enumFieldType) {
                    case 1: {
                        value = new Boolean(false);
                        break;
                    }
                    case 2: {
                        value = new Character('\u0000');
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        value = this.convertValue(new Integer(0), sm);
                    }
                }
            }
            ((PersistenceCapable)sm.getPersistent()).jdoSetField(this.absoluteID, value);
        } else {
            if (debug) {
                Object[] items = new Object[]{this.getName(), value};
                logger.finest("sqlstore.model.fielddesc.fieldname", items);
            }
            sm.setHiddenValue(this.absoluteID, value);
        }
    }

    public ArrayList getTrackedFields() {
        return this.trackedFields;
    }

    public boolean isKeyField() {
        return (this.sqlProperties & 0x100) > 0;
    }

    public boolean isForeignKeyField() {
        return (this.sqlProperties & 0x400) > 0;
    }

    public boolean isRelationshipField() {
        return false;
    }

    public Object convertValue(Object value, StateManager sm) {
        boolean debug = logger.isLoggable(300);
        if (value == null) {
            if (debug) {
                logger.finest("sqlstore.model.fielddesc.convertvalue");
            }
            return value;
        }
        if (this.absoluteID < 0) {
            if (debug) {
                logger.finest("sqlstore.model.fielddesc.convertvalue.hidden", (Object)new Integer(this.absoluteID));
            }
            return value;
        }
        if (debug) {
            Object[] items = new Object[]{value, value.getClass().getName(), this.fieldType};
            logger.finest("sqlstore.model.fielddesc.convertvalue.from_to", items);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            switch (this.enumFieldType) {
                case 1: 
                case 11: {
                    if (number.doubleValue() == 0.0) {
                        value = new Boolean(false);
                        break;
                    }
                    value = new Boolean(true);
                    break;
                }
                case 3: 
                case 13: {
                    if (value instanceof Byte) break;
                    this.assertIsValid(number, -128.0, 127.0);
                    value = new Byte(number.byteValue());
                    break;
                }
                case 4: 
                case 14: {
                    if (value instanceof Short) break;
                    this.assertIsValid(number, -32768.0, 32767.0);
                    value = new Short(number.shortValue());
                    break;
                }
                case 5: 
                case 15: {
                    if (value instanceof Integer) break;
                    this.assertIsValid(number, -2.147483648E9, 2.147483647E9);
                    value = new Integer(number.intValue());
                    break;
                }
                case 6: 
                case 16: {
                    if (value instanceof Long) break;
                    this.assertIsValidLong(number);
                    value = new Long(number.longValue());
                    break;
                }
                case 7: 
                case 17: {
                    if (value instanceof Float) break;
                    value = new Float(number.floatValue());
                    break;
                }
                case 8: 
                case 18: {
                    if (value instanceof Double) break;
                    if (value instanceof Float) {
                        value = new Double(number.toString());
                        break;
                    }
                    value = new Double(number.doubleValue());
                    break;
                }
                case 19: {
                    if (value instanceof BigDecimal) break;
                    if (value instanceof Double) {
                        value = new BigDecimal(number.doubleValue());
                        break;
                    }
                    if (value instanceof BigInteger) {
                        value = new BigDecimal((BigInteger)value);
                        break;
                    }
                    value = new BigDecimal(number.toString());
                    break;
                }
                case 20: {
                    if (value instanceof BigInteger) break;
                    value = value instanceof BigDecimal ? ((BigDecimal)value).toBigInteger() : new BigInteger(number.toString());
                }
            }
        } else {
            switch (this.enumFieldType) {
                case 21: {
                    if (value instanceof String) break;
                    value = value.toString();
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    value = this.convertToDateFieldType(value, sm);
                    break;
                }
                case 2: 
                case 12: {
                    if (value instanceof Character) break;
                    String str = value.toString();
                    value = FieldDesc.getCharFromString(str);
                    break;
                }
                case 1: 
                case 11: {
                    if (value instanceof Boolean) break;
                    if (value instanceof String && value.equals("1")) {
                        value = "true";
                    }
                    value = new Boolean(value.toString());
                }
            }
        }
        return value;
    }

    public Object createSCO(Object value, StateManager sm) {
        Object retVal = null;
        PersistenceManager pm = null;
        if (sm != null) {
            pm = (PersistenceManager)sm.getPersistenceManagerInternal();
        }
        if (pm != null && pm.getRequireTrackedSCO()) {
            retVal = pm.newSCOInstanceInternal(this.fieldType, sm.getPersistent(), this.getName());
            this.initializeSCO(retVal, value);
        }
        return retVal;
    }

    public static Character getCharFromString(String str) {
        Character retVal = null;
        retVal = str.length() == 0 ? new Character('\u0000') : new Character(str.charAt(0));
        return retVal;
    }

    private Object convertToDateFieldType(Object value, StateManager sm) {
        Object retVal;
        if (value instanceof SCO) {
            ((SCO)value).unsetOwner();
        }
        if ((retVal = this.createSCO(value, sm)) == null) {
            retVal = this.convertToDateFieldType(value);
        }
        return retVal;
    }

    private Object convertToDateFieldType(Object value) {
        Object retVal = value;
        if (!this.fieldType.equals(value.getClass()) && value instanceof java.util.Date) {
            switch (this.enumFieldType) {
                case 22: {
                    retVal = new java.util.Date(((java.util.Date)value).getTime());
                    break;
                }
                case 23: {
                    retVal = new Date(((java.util.Date)value).getTime());
                    break;
                }
                case 24: {
                    retVal = new Time(((java.util.Date)value).getTime());
                    break;
                }
                case 25: {
                    retVal = new Timestamp(((java.util.Date)value).getTime());
                    if (!(value instanceof Timestamp)) break;
                    ((Timestamp)retVal).setNanos(((Timestamp)value).getNanos());
                    break;
                }
            }
        }
        return retVal;
    }

    private void initializeSCO(Object scoVal, Object value) {
        switch (this.enumFieldType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (!(value instanceof java.util.Date)) break;
                ((SCODate)scoVal).setTimeInternal(((java.util.Date)value).getTime());
                if (this.enumFieldType != 25 || !(value instanceof Timestamp)) break;
                ((SqlTimestamp)scoVal).setNanosInternal(((Timestamp)value).getNanos());
                break;
            }
        }
    }

    private void assertIsValid(Number number, double min_value, double max_value) {
        double x = number.doubleValue();
        if (x < min_value) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.minvalue", number, String.valueOf(min_value), this.fieldType.getName()));
        }
        if (x > max_value) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.maxvalue", number, String.valueOf(max_value), this.fieldType.getName()));
        }
    }

    private void assertIsValidLong(Number number) {
        BigDecimal bd = null;
        bd = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        if (bd.compareTo(LONG_MIN_VALUE) < 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.minvalue", number, String.valueOf(Long.MIN_VALUE), this.fieldType.getName()));
        }
        if (bd.compareTo(LONG_MAX_VALUE) > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "core.fielddesc.maxvalue", number, String.valueOf(Long.MAX_VALUE), this.fieldType.getName()));
        }
    }

    void setupDesc(final Class classType, final String name) {
        Field f = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return classType.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    throw new JDOFatalUserException(I18NHelper.getMessage(messages, "core.configuration.loadfailed.field", name, classType.getName()), e);
                }
            }
        });
        this.setupDesc(f);
    }

    protected void setupDesc(Field f) {
        this.field = f;
        this.fieldName = f.getName();
        this.declaringClass = this.field.getDeclaringClass();
        this.fieldType = this.field.getType();
        this.enumFieldType = FieldDesc.translateToEnumType(this.fieldType);
        if (logger.isLoggable(300)) {
            Object[] items = new Object[]{this.fieldName, this.fieldType};
            logger.finest("sqlstore.model.fielddesc.setupdesc", items);
        }
    }

    private static int translateToEnumType(Class fldType) {
        int retVal = 0;
        if (fldType == Boolean.TYPE) {
            retVal = 1;
        } else if (fldType == Character.TYPE) {
            retVal = 2;
        } else if (fldType == Byte.TYPE) {
            retVal = 3;
        } else if (fldType == Short.TYPE) {
            retVal = 4;
        } else if (fldType == Integer.TYPE) {
            retVal = 5;
        } else if (fldType == Long.TYPE) {
            retVal = 6;
        } else if (fldType == Float.TYPE) {
            retVal = 7;
        } else if (fldType == Double.TYPE) {
            retVal = 8;
        } else if (fldType == Boolean.class) {
            retVal = 11;
        } else if (fldType == Character.class) {
            retVal = 12;
        } else if (fldType == Byte.class) {
            retVal = 13;
        } else if (fldType == Short.class) {
            retVal = 14;
        } else if (fldType == Integer.class) {
            retVal = 15;
        } else if (fldType == Long.class) {
            retVal = 16;
        } else if (fldType == Float.class) {
            retVal = 17;
        } else if (fldType == Double.class) {
            retVal = 18;
        } else if (fldType == BigDecimal.class) {
            retVal = 19;
        } else if (fldType == BigInteger.class) {
            retVal = 20;
        } else if (fldType == String.class) {
            retVal = 21;
        } else if (fldType == java.util.Date.class) {
            retVal = 22;
        } else if (fldType == Date.class) {
            retVal = 23;
        } else if (fldType == Time.class) {
            retVal = 24;
        } else if (fldType == Timestamp.class) {
            retVal = 25;
        } else if (fldType.isArray() && fldType.getComponentType() == Byte.TYPE) {
            retVal = 51;
        }
        return retVal;
    }

    void setComponentType(Class type) {
        this.componentType = type;
    }

    protected void addTrackedField(FieldDesc f) {
        if (this.trackedFields == null) {
            this.trackedFields = new ArrayList();
        }
        if (logger.isLoggable(300)) {
            Object[] items = new Object[]{f.getName(), this.getName()};
            logger.finest("sqlstore.model.fielddesc.addingfield", items);
        }
        this.trackedFields.add(f);
    }

    abstract void computeTrackedRelationshipFields();

    static boolean compareColumns(FieldDesc f1, FieldDesc f2) {
        ArrayList columnList1 = null;
        ArrayList columnList2 = null;
        ArrayList columnList3 = null;
        ArrayList columnList4 = null;
        boolean exactMatch = false;
        if (f1 instanceof LocalFieldDesc) {
            columnList1 = ((LocalFieldDesc)f1).columnDescs;
            if (f2 instanceof LocalFieldDesc) {
                columnList2 = ((LocalFieldDesc)f2).columnDescs;
                exactMatch = true;
            } else {
                columnList2 = ((ForeignFieldDesc)f2).localColumns;
            }
        } else {
            if (f2 instanceof LocalFieldDesc) {
                return false;
            }
            ForeignFieldDesc ff1 = (ForeignFieldDesc)f1;
            ForeignFieldDesc ff2 = (ForeignFieldDesc)f2;
            if (ff1.useJoinTable() && ff2.useJoinTable()) {
                columnList1 = ff1.assocLocalColumns;
                columnList2 = ff2.assocLocalColumns;
                columnList3 = ff1.assocForeignColumns;
                columnList4 = ff2.assocForeignColumns;
            } else if (!ff1.useJoinTable() && !ff2.useJoinTable()) {
                columnList1 = ff1.localColumns;
                columnList2 = ff2.localColumns;
                columnList3 = ff1.foreignColumns;
                columnList4 = ff2.foreignColumns;
            } else {
                return false;
            }
            exactMatch = true;
        }
        boolean found = false;
        for (int k = 0; k < 2; ++k) {
            if (k == 1) {
                if (columnList3 == null) break;
                columnList1 = columnList3;
                columnList2 = columnList4;
            }
            int size1 = columnList1.size();
            int size2 = columnList2.size();
            if (exactMatch && size1 != size2) {
                return false;
            }
            for (int i = 0; i < size1; ++i) {
                found = false;
                ColumnElement c1 = (ColumnElement)columnList1.get(i);
                for (int j = 0; j < size2; ++j) {
                    ColumnElement c2 = (ColumnElement)columnList2.get(j);
                    if (!c1.getName().getFullName().equals(c2.getName().getFullName())) continue;
                    found = true;
                }
                if (exactMatch && !found) {
                    return false;
                }
                if (exactMatch || !found) continue;
                return true;
            }
        }
        return found;
    }
}

