/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.webservices.deployment.DeployedEndpointData;

@AMXMetadata(type="web-service-mon", group="monitoring")
@ManagedObject
@Description(value="Stats for Web Services deployed")
public class WebServiceStatsProvider {
    private final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
    private final Map<String, List<DeployedEndpointData>> riEndpoints = new HashMap<String, List<DeployedEndpointData>>();

    @ProbeListener(value="glassfish:webservices:deployment-ri:deploy")
    public synchronized void riDeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        List<DeployedEndpointData> ri;
        String contextPath = adapter.getServletContext().getContextPath();
        String path = contextPath + adapter.getValidPath();
        DeployedEndpointData data = this.endpoints.get(path);
        if (data == null) {
            data = new DeployedEndpointData(path, adapter);
            this.endpoints.put(path, data);
        }
        if ((ri = this.riEndpoints.get(contextPath)) == null) {
            ri = new ArrayList<DeployedEndpointData>();
            this.riEndpoints.put(contextPath, ri);
        }
        ri.add(data);
    }

    @ProbeListener(value="glassfish:webservices:deployment-ri:undeploy")
    public synchronized void riUndeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        ServletContext ctxt = adapter.getServletContext();
        String name = ctxt.getContextPath() + adapter.getValidPath();
        DeployedEndpointData data = this.endpoints.remove(name);
        String contextPath = adapter.getServletContext().getContextPath();
        List<DeployedEndpointData> ri = this.riEndpoints.get(contextPath);
        if (ri != null) {
            ri.remove(data);
            if (ri.isEmpty()) {
                this.riEndpoints.remove(contextPath);
            }
        }
    }

    @ManagedAttribute
    @Description(value="Deployed Web Service Endpoints")
    public synchronized MyStats getEndpoints() {
        return new MyStats(this.endpoints);
    }

    @ManagedOperation
    public synchronized List<Map<String, String>> getRiEndpoint(String contextPath) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List<DeployedEndpointData> ri = this.riEndpoints.get(contextPath);
        if (ri != null) {
            for (DeployedEndpointData de : ri) {
                list.add(de.getStaticAsMap());
            }
        }
        return list;
    }

    @ManagedData
    private static class MyStats
    implements Stats {
        final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
        final DeployedEndpointData[] data;

        MyStats(Map<String, DeployedEndpointData> curEndpoints) {
            this.endpoints.putAll(curEndpoints);
            this.data = this.endpoints.values().toArray(new DeployedEndpointData[this.endpoints.size()]);
        }

        public Statistic getStatistic(String s) {
            return (Statistic)this.endpoints.get(s);
        }

        public String[] getStatisticNames() {
            Set<String> names = this.endpoints.keySet();
            return names.toArray(new String[names.size()]);
        }

        @ManagedAttribute
        public DeployedEndpointData[] getStatistics() {
            return this.data;
        }
    }
}

