/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.List;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.client.CFClient;
import org.eclipse.cft.server.core.internal.log.CFApplicationLogListener;
import org.eclipse.cft.server.core.internal.log.CFStreamingLogToken;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.core.runtime.CoreException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class HybridClient
implements CFClient {
    private final CloudFoundryOperations v1Client;
    private final CFClient otherClient;

    public HybridClient(CloudFoundryOperations v1Client, CFClient otherClient) {
        this.v1Client = v1Client;
        this.otherClient = otherClient;
    }

    @Override
    public String login() throws CoreException {
        try {
            OAuth2AccessToken oauth = this.v1Client.login();
            if (oauth != null) {
                String asJson = CloudUtil.getTokenAsJson(oauth);
                this.otherClient.login();
                return asJson;
            }
        }
        catch (Throwable e) {
            throw CloudErrorUtil.toCoreException(e);
        }
        throw CloudErrorUtil.toCoreException("Failed to login using v1 client. No OAuth2AccessToken resolved. Check if credentials or passcode are valid.");
    }

    @Override
    public CFStreamingLogToken streamLogs(String appName, CFApplicationLogListener listener) throws CoreException {
        return this.otherClient.streamLogs(appName, listener);
    }

    @Override
    public List<CloudLog> getRecentLogs(String appName) throws CoreException {
        return this.otherClient.getRecentLogs(appName);
    }
}

