/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.preferences;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProxyPreferenceStore
implements IEclipsePreferences {
    private final IEclipsePreferences instanceScope;
    private final IEclipsePreferences defaultScope;
    private final Map<String, String> preferences = new HashMap<String, String>();
    private ListenerList preferenceChangeListeners;
    private IEclipsePreferences.IPreferenceChangeListener delegateChangesListener;

    public ProxyPreferenceStore(IEclipsePreferences instanceScope, IEclipsePreferences defaultScope) {
        this.instanceScope = instanceScope;
        this.defaultScope = defaultScope;
        this.load();
        this.delegateChangesListener = new DelegateChangesListener();
        instanceScope.addPreferenceChangeListener(this.delegateChangesListener);
    }

    public void resetToDefault() {
        try {
            String[] stringArray = this.defaultScope.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.put(key, this.defaultScope.get(key, ""));
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void dispose() {
        this.instanceScope.removePreferenceChangeListener(this.delegateChangesListener);
        this.delegateChangesListener = null;
        this.preferenceChangeListeners.clear();
        try {
            this.clear();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void put(String key, String value) {
        String oldValue = this.preferences.put(key, value);
        if (oldValue == null || !oldValue.equals(value)) {
            this.firePreferenceChangeEvent(key, oldValue, value);
        }
    }

    public String get(String key, String def) {
        return this.preferences.get(key);
    }

    public void remove(String key) {
        String oldValue = this.preferences.remove(key);
        this.firePreferenceChangeEvent(key, oldValue, null);
    }

    public void clear() throws BackingStoreException {
        for (String key : new LinkedHashSet<String>(this.preferences.keySet())) {
            this.remove(key);
        }
    }

    public void putInt(String key, int value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Integer.toString(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public int getInt(String key, int def) {
        String value = this.preferences.get(key);
        int result = def;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putLong(String key, long value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Long.toString(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public long getLong(String key, long def) {
        String value = this.preferences.get(key);
        long result = def;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putBoolean(String key, boolean value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Boolean.toString(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.preferences.get(key);
        boolean result = def;
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public void putFloat(String key, float value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Float.toString(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public float getFloat(String key, float def) {
        String value = this.preferences.get(key);
        float result = def;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putDouble(String key, double value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Double.toString(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public double getDouble(String key, double def) {
        String value = this.preferences.get(key);
        double result = def;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public void putByteArray(String key, byte[] value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = new String(value);
        String oldValue = this.preferences.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.firePreferenceChangeEvent(key, oldValue, newValue);
        }
    }

    public byte[] getByteArray(String key, byte[] def) {
        String value = this.preferences.get(key);
        byte[] result = def;
        if (value != null) {
            result = value.getBytes();
        }
        return result;
    }

    public String[] keys() throws BackingStoreException {
        Set<String> keys = this.preferences.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceChangeListeners == null) {
            this.preferenceChangeListeners = new ListenerList();
        }
        this.preferenceChangeListeners.add((Object)listener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (this.preferenceChangeListeners != null) {
            this.preferenceChangeListeners.remove((Object)listener);
        }
    }

    public void propagate() {
        for (Map.Entry<String, String> entry : this.preferences.entrySet()) {
            String originValue = this.instanceScope.get(entry.getKey(), null);
            if (originValue != null && originValue.equals(entry.getValue())) continue;
            this.instanceScope.put(entry.getKey(), entry.getValue());
        }
        try {
            this.instanceScope.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void load() {
        try {
            String key;
            String[] stringArray = this.defaultScope.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                this.preferences.put(key, this.defaultScope.get(key, ""));
                ++n2;
            }
            stringArray = this.instanceScope.keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                key = stringArray[n2];
                this.preferences.put(key, this.instanceScope.get(key, ""));
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void firePreferenceChangeEvent(String key, Object oldValue, Object newValue) {
        if (this.preferenceChangeListeners != null) {
            final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, oldValue, newValue);
            Object[] objectArray = this.preferenceChangeListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                if (listener instanceof IEclipsePreferences.IPreferenceChangeListener) {
                    ISafeRunnable job = new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            ((IEclipsePreferences.IPreferenceChangeListener)listener).preferenceChange(event);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)job);
                }
                ++n2;
            }
        }
    }

    public void removeNode() throws BackingStoreException {
    }

    public Preferences node(String path) {
        return null;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
    }

    public String[] childrenNames() throws BackingStoreException {
        return new String[0];
    }

    public Preferences parent() {
        return null;
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return false;
    }

    public String name() {
        return null;
    }

    public String absolutePath() {
        return null;
    }

    public void flush() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
    }

    private class DelegateChangesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private DelegateChangesListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String currentValue;
            String key = event.getKey();
            Object newValue = event.getNewValue();
            if (newValue instanceof String && ((currentValue = (String)ProxyPreferenceStore.this.preferences.get(key)) == null || !currentValue.equals(newValue))) {
                ProxyPreferenceStore.this.put(key, (String)newValue);
            }
        }
    }
}

