/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import org.eclipse.fordiac.ide.model.AbstractStructTree;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.viewers.TreeViewer;

public class CheckableStructTree
extends AbstractStructTree<CheckableStructTreeNode> {
    public CheckableStructTree(StructManipulator manipulator, StructuredType struct, TreeViewer viewer) {
        super(manipulator, struct, viewer);
    }

    public CheckableStructTree(StructManipulator manipulator, StructuredType struct) {
        super(manipulator, struct);
    }

    @Override
    public void buildTree(StructManipulator struct, StructuredType structType, CheckableStructTreeNode parent) {
        for (VarDeclaration memberVariable : structType.getMemberVariables()) {
            DataType dataType;
            CheckableStructTreeNode treeNode = parent.addChild(memberVariable);
            IInterfaceElement variablePin = struct.getInterfaceElement(treeNode.getPinName());
            if (variablePin != null && !(variablePin instanceof ErrorMarkerInterface)) {
                treeNode.check(true);
            }
            if ((dataType = memberVariable.getType()) instanceof StructuredType) {
                StructuredType structuredtype = (StructuredType)dataType;
                if (memberVariable.getType() != IecTypes.GenericTypes.ANY_STRUCT && !memberVariable.isArray()) {
                    this.buildTree(struct, structuredtype, treeNode);
                    continue;
                }
            }
            if (!treeNode.isChecked()) continue;
            CheckableStructTreeNode.greyParents(treeNode);
        }
    }

    @Override
    public CheckableStructTreeNode createRoot() {
        return new CheckableStructTreeNode(this);
    }
}

