/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.BlockTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.OtherMethod;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECAction;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECState;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextMethod;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class FBTImporter
extends BlockTypeImporter {
    private final Map<String, List<ECAction>> algorithmNameECActionMapping = new HashMap<String, List<ECAction>>();
    private final Map<String, ECState> ecStates = new HashMap<String, ECState>();

    public FBTImporter(IFile typeFile) {
        super(typeFile);
    }

    public FBTImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    protected FBTImporter(CommonElementImporter importer) {
        super(importer);
    }

    @Override
    protected LibraryElement createRootModelElement() {
        ServiceInterfaceFBType newType = LibraryElementFactory.eINSTANCE.createServiceInterfaceFBType();
        newType.setService(LibraryElementFactory.eINSTANCE.createService());
        return newType;
    }

    @Override
    protected String getStartElementName() {
        return "FBType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "InterfaceList": {
                    this.getElement().setInterfaceList(this.getInterfaceListImporter().parseInterfaceList("InterfaceList"));
                    break;
                }
                case "BasicFB": {
                    this.setElement(FBTImporter.convertToBasicType(this.getElement()));
                    this.parseBasicFB((BasicFBType)this.getElement());
                    break;
                }
                case "SimpleFB": {
                    this.setElement(FBTImporter.convertToSimpleType(this.getElement()));
                    this.parseSimpleFB((SimpleFBType)this.getElement());
                    break;
                }
                case "FBNetwork": {
                    this.setElement(FBTImporter.convertToCompositeType(this.getElement()));
                    this.parseFBNetwork((CompositeFBType)this.getElement());
                    break;
                }
                case "Service": {
                    this.parseService(this.getElement());
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    private static void copyGeneralTypeInformation(FBType dstType, FBType srcType) {
        dstType.setName(srcType.getName());
        dstType.setComment(srcType.getComment());
        dstType.setCompilerInfo(srcType.getCompilerInfo());
        dstType.setInterfaceList(srcType.getInterfaceList());
        dstType.setIdentification(srcType.getIdentification());
        dstType.getVersionInfo().addAll(srcType.getVersionInfo());
        dstType.setService(srcType.getService());
        dstType.getAttributes().addAll((Collection)srcType.getAttributes());
    }

    private void parseFBNetwork(CompositeFBType type) throws TypeImportException, XMLStreamException {
        FBNetwork fbNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        type.setFBNetwork(fbNetwork);
        this.addAdaptersToFBNetwork(fbNetwork);
        FBNetworkImporter fbnInmporter = new FBNetworkImporter((CommonElementImporter)this, fbNetwork, type.getInterfaceList());
        fbnInmporter.parseFBNetwork("FBNetwork");
    }

    private void addAdaptersToFBNetwork(FBNetwork fbNetwork) {
        this.getElement().getInterfaceList().getPlugs().forEach(plg -> FBTImporter.addAdapterFBToNetwork(fbNetwork, plg));
        this.getElement().getInterfaceList().getSockets().forEach(sct -> FBTImporter.addAdapterFBToNetwork(fbNetwork, sct));
    }

    private static void addAdapterFBToNetwork(FBNetwork fbNetwork, AdapterDeclaration adapterDecl) {
        AdapterFB adapterFB = adapterDecl.getAdapterFB();
        fbNetwork.getNetworkElements().add((Object)adapterFB);
    }

    private static FBType convertToCompositeType(FBType type) {
        CompositeFBType compositeType = LibraryElementFactory.eINSTANCE.createCompositeFBType();
        FBTImporter.copyGeneralTypeInformation(compositeType, type);
        return compositeType;
    }

    private void parseBasicFB(BasicFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("BasicFB", name -> this.handleBasicFBChildren(type, name));
    }

    private boolean handleBasicFBChildren(BasicFBType type, String name) throws TypeImportException, XMLStreamException {
        if ("ECC".equals(name)) {
            this.parseECC(type);
            return true;
        }
        return this.handleBaseFBChildren(type, name);
    }

    private void parseSimpleFB(SimpleFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("SimpleFB", name -> this.handleSimpleFBChildren(type, name));
        EList<Event> inEvents = type.getInterfaceList().getEventInputs();
        if (inEvents.size() > type.getSimpleECStates().size()) {
            EList<Event> outEvents = type.getInterfaceList().getEventOutputs();
            Event stdOutEvent = !outEvents.isEmpty() ? (Event)outEvents.get(0) : null;
            LinkedHashSet<Event> inEventSet = new LinkedHashSet<Event>((Collection<Event>)inEvents);
            for (SimpleECState state : type.getSimpleECStates()) {
                inEventSet.remove(state.getInputEvent());
            }
            for (Event inEvent : inEventSet) {
                SimpleECState state = LibraryElementFactory.eINSTANCE.createSimpleECState();
                state.setName(inEvent.getName());
                state.setInputEvent(inEvent);
                SimpleECAction action = LibraryElementFactory.eINSTANCE.createSimpleECAction();
                action.setAlgorithm(inEvent.getName());
                action.setOutput(stdOutEvent);
                state.getSimpleECActions().add((Object)action);
                type.getSimpleECStates().add((Object)state);
            }
        }
    }

    private boolean handleSimpleFBChildren(SimpleFBType type, String name) throws TypeImportException, XMLStreamException {
        if ("ECState".equals(name)) {
            this.parseSimpleECState(type);
            return true;
        }
        return this.handleBaseFBChildren(type, name);
    }

    private boolean handleBaseFBChildren(BaseFBType type, String name) throws TypeImportException, XMLStreamException {
        switch (name) {
            case "InternalVars": {
                this.parseInternalVars(type);
                break;
            }
            case "InternalConstVars": {
                this.parseInternalConstVars(type);
                break;
            }
            case "Algorithm": {
                Algorithm alg = this.parseAlgorithm();
                if (alg == null) break;
                type.getCallables().add((Object)alg);
                List<ECAction> list = this.algorithmNameECActionMapping.get(alg.getName());
                if (list == null) break;
                for (ECAction action : list) {
                    action.setAlgorithm(alg);
                }
                break;
            }
            case "Method": {
                Method method = this.parseMethod();
                if (method == null) break;
                type.getCallables().add((Object)method);
                break;
            }
            case "Attribute": {
                this.parseGenericAttributeNode(this.getElement());
                this.proceedToEndElementNamed("Attribute");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private Algorithm parseAlgorithm() throws TypeImportException, XMLStreamException {
        String name = this.getAttributeValue("Name");
        String comment = this.getAttributeValue("Comment");
        INamedElement retVal = null;
        block11: while (this.getReader().hasNext()) {
            int event;
            block17: {
                event = this.getReader().next();
                if (1 != event) break block17;
                switch (this.getReader().getLocalName()) {
                    case "LD": 
                    case "FBD": {
                        throw new TypeImportException("Algorithm: Unsupported Algorithmtype (only ST and Other possible)!");
                    }
                    case "ST": {
                        retVal = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
                        this.parseST((STAlgorithm)retVal);
                        continue block11;
                    }
                    case "Other": {
                        retVal = LibraryElementFactory.eINSTANCE.createOtherAlgorithm();
                        this.parseOtherAlg((OtherAlgorithm)retVal);
                        continue block11;
                    }
                    default: {
                        throw this.unknownXMLChildException();
                    }
                }
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals("Algorithm")) break;
            throw new XMLStreamException("Unexpected xml end tag found in Algorithm: " + this.getReader().getLocalName());
        }
        if (retVal != null) {
            retVal.setName(name);
            retVal.setComment(comment);
        }
        return retVal;
    }

    private void parseOtherAlg(OtherAlgorithm alg) throws TypeImportException, XMLStreamException {
        String language = this.getAttributeValue("Language");
        if (language == null) {
            throw new TypeImportException(Messages.FBTImporter_OTHER_ALG_MISSING_LANG_EXCEPTION);
        }
        alg.setLanguage(language);
        this.parseAlgorithmText(alg);
        this.proceedToEndElementNamed("Other");
    }

    private void parseST(STAlgorithm st) throws XMLStreamException {
        this.parseAlgorithmText(st);
        this.proceedToEndElementNamed("ST");
    }

    private void parseAlgorithmText(TextAlgorithm alg) throws XMLStreamException {
        String text = this.getAttributeValue("Text");
        if (text != null) {
            alg.setText(text);
        } else {
            alg.setText(this.readCDataSection());
        }
    }

    private Method parseMethod() throws TypeImportException, XMLStreamException {
        String name = this.getAttributeValue("Name");
        String comment = this.getAttributeValue("Comment");
        DataType type = null;
        String typeName = this.getAttributeValue("Type");
        if (typeName != null && !typeName.isEmpty()) {
            type = this.getType(typeName, this.getDataTypeLibrary()::getType);
        }
        INamedElement retVal = null;
        block19: while (this.getReader().hasNext()) {
            int event;
            block35: {
                event = this.getReader().next();
                if (1 != event) break block35;
                switch (this.getReader().getLocalName()) {
                    case "LD": 
                    case "FBD": {
                        throw new TypeImportException("Method: Unsupported type (only ST and Other possible)!");
                    }
                    case "ST": {
                        retVal = LibraryElementFactory.eINSTANCE.createSTMethod();
                        this.parseSTMethod((STMethod)retVal);
                        continue block19;
                    }
                    case "Other": {
                        retVal = LibraryElementFactory.eINSTANCE.createOtherMethod();
                        this.parseOtherMethod((OtherMethod)retVal);
                        continue block19;
                    }
                    case "InputVars": {
                        if (retVal == null) {
                            throw this.unknownXMLChildException();
                        }
                        this.parseParameterList("InputVars", retVal.getInputParameters(), true);
                        continue block19;
                    }
                    case "OutputVars": {
                        if (retVal == null) {
                            throw this.unknownXMLChildException();
                        }
                        this.parseParameterList("OutputVars", retVal.getOutputParameters(), false);
                        continue block19;
                    }
                    case "InOutVars": {
                        if (retVal == null) {
                            throw this.unknownXMLChildException();
                        }
                        this.parseParameterList("InOutVars", retVal.getInOutParameters(), true);
                        continue block19;
                    }
                    case "VarDeclaration": {
                        if (retVal == null) {
                            throw this.unknownXMLChildException();
                        }
                        VarDeclaration declaration = this.parseVarDeclaration();
                        retVal.getInputParameters().add((Object)declaration);
                        continue block19;
                    }
                    default: {
                        throw this.unknownXMLChildException();
                    }
                }
            }
            if (2 != event) continue;
            if (this.getReader().getLocalName().equals("Method")) break;
            throw new XMLStreamException("Unexpected xml end tag found in Method: " + this.getReader().getLocalName());
        }
        if (retVal != null) {
            retVal.setName(name);
            retVal.setComment(comment);
        }
        if (retVal instanceof TextMethod) {
            TextMethod textMethod = (TextMethod)retVal;
            textMethod.setReturnType(type);
        }
        return retVal;
    }

    private void parseParameterList(String nodeName, EList<? super VarDeclaration> varList, boolean input) throws TypeImportException, XMLStreamException {
        this.processChildren(nodeName, name -> {
            if (name.equals("VarDeclaration")) {
                VarDeclaration v = this.parseVarDeclaration();
                varList.add((Object)v);
                v.setIsInput(input);
                return true;
            }
            return false;
        });
    }

    protected XMLStreamException unknownXMLChildException() {
        return new XMLStreamException("Unexpected xml child (" + this.getReader().getLocalName() + ") found!");
    }

    private void parseOtherMethod(OtherMethod method) throws TypeImportException, XMLStreamException {
        String language = this.getAttributeValue("Language");
        if (language == null) {
            throw new TypeImportException(Messages.FBTImporter_OTHER_METHOD_MISSING_LANG_EXCEPTION);
        }
        method.setLanguage(language);
        this.parseMethodText(method);
        this.proceedToEndElementNamed("Other");
    }

    private void parseSTMethod(STMethod method) throws XMLStreamException {
        this.parseMethodText(method);
        this.proceedToEndElementNamed("ST");
    }

    private void parseMethodText(TextMethod method) throws XMLStreamException {
        String text = this.getAttributeValue("Text");
        if (text != null) {
            method.setText(text);
        } else {
            method.setText(this.readCDataSection());
        }
    }

    private void parseECC(BasicFBType type) throws TypeImportException, XMLStreamException {
        ECC ecc = LibraryElementFactory.eINSTANCE.createECC();
        this.processChildren("ECC", name -> {
            switch (name) {
                case "ECState": {
                    this.parseECState(ecc);
                    break;
                }
                case "ECTransition": {
                    this.parseECTransition(ecc);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        type.setECC(ecc);
    }

    private void parseECTransition(ECC ecc) throws TypeImportException, XMLStreamException {
        String condition;
        ECTransition ecTransition = LibraryElementFactory.eINSTANCE.createECTransition();
        String source = this.getAttributeValue("Source");
        if (source != null) {
            ECState state = this.ecStates.get(source);
            if (state != null) {
                ecTransition.setSource(state);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_SOURCE_EXCEPTION);
        }
        String destination = this.getAttributeValue("Destination");
        if (destination == null) {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_DEST_EXCEPTION);
        }
        ECState state = this.ecStates.get(destination);
        if (state != null) {
            ecTransition.setDestination(state);
        }
        if ((condition = this.getAttributeValue("Condition")) == null) {
            throw new TypeImportException(Messages.FBTImporter_ECTRANASITION_CONDITION_EXCEPTION);
        }
        this.validateTransitionCondition(ecTransition, condition);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            ecTransition.setComment(comment);
        }
        this.getXandY(ecTransition);
        this.proceedToEndElementNamed("ECTransition");
        ecc.getECTransition().add((Object)ecTransition);
    }

    private void validateTransitionCondition(ECTransition ecTransition, String condition) {
        String expression;
        String[] split = condition.split("&", 2);
        Event event = this.getInterfaceListImporter().getInputEvents().get(split[0].trim());
        if (event != null) {
            expression = split.length > 1 ? split[1].trim() : "";
        } else {
            split = condition.split("\\[", 2);
            event = this.getInterfaceListImporter().getInputEvents().get(split[0].trim());
            expression = event != null ? (split.length > 1 ? split[1].substring(0, split[1].lastIndexOf(93)).trim() : "") : (condition.startsWith("[") ? condition.substring(1, condition.lastIndexOf(93)) : condition);
        }
        ecTransition.setConditionEvent(event);
        ecTransition.setConditionExpression(expression);
    }

    private void parseECState(ECC ecc) throws TypeImportException, XMLStreamException {
        ECState state = LibraryElementFactory.eINSTANCE.createECState();
        this.readNameCommentAttributes(state);
        this.getXandY(state);
        this.processChildren("ECState", name -> {
            if ("ECAction".equals(name)) {
                this.parseECAction(state);
                return true;
            }
            return false;
        });
        if (ecc.getECState().isEmpty()) {
            ecc.setStart(state);
        }
        ecc.getECState().add((Object)state);
        this.ecStates.put(state.getName(), state);
    }

    private void parseECAction(ECState type) throws XMLStreamException {
        Event outp;
        String output;
        ECAction ecAction = LibraryElementFactory.eINSTANCE.createECAction();
        String algorithm = this.getAttributeValue("Algorithm");
        if (algorithm != null) {
            if (this.algorithmNameECActionMapping.containsKey(algorithm)) {
                this.algorithmNameECActionMapping.get(algorithm).add(ecAction);
            } else {
                ArrayList<ECAction> temp = new ArrayList<ECAction>();
                temp.add(ecAction);
                this.algorithmNameECActionMapping.put(algorithm, temp);
            }
        }
        if ((output = this.getAttributeValue("Output")) != null && (outp = this.getInterfaceListImporter().getOutputEvents().get(output)) != null) {
            ecAction.setOutput(outp);
        }
        this.proceedToEndElementNamed("ECAction");
        type.getECAction().add((Object)ecAction);
    }

    private void parseSimpleECState(SimpleFBType type) throws TypeImportException, XMLStreamException {
        SimpleECState state = LibraryElementFactory.eINSTANCE.createSimpleECState();
        this.readNameCommentAttributes(state);
        state.setInputEvent(type.getInterfaceList().getEvent(state.getName()));
        this.processChildren("ECState", name -> {
            if ("ECAction".equals(name)) {
                this.parseSimpleECAction(state);
                return true;
            }
            return false;
        });
        type.getSimpleECStates().add((Object)state);
    }

    private void parseSimpleECAction(SimpleECState type) throws XMLStreamException {
        Event outp;
        SimpleECAction ecAction = LibraryElementFactory.eINSTANCE.createSimpleECAction();
        ecAction.setAlgorithm(this.getAttributeValue("Algorithm"));
        String output = this.getAttributeValue("Output");
        if (output != null && (outp = this.getInterfaceListImporter().getOutputEvents().get(output)) != null) {
            ecAction.setOutput(outp);
        }
        this.proceedToEndElementNamed("ECAction");
        type.getSimpleECActions().add((Object)ecAction);
    }

    private void parseInternalVars(BaseFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("InternalVars", name -> {
            if ("VarDeclaration".equals(name)) {
                VarDeclaration v = this.parseVarDeclaration();
                type.getInternalVars().add((Object)v);
                return true;
            }
            if ("FB".equals(name)) {
                this.parseInternalFB(type);
                return true;
            }
            return false;
        });
    }

    private void parseInternalConstVars(BaseFBType type) throws TypeImportException, XMLStreamException {
        this.processChildren("InternalConstVars", name -> {
            if ("VarDeclaration".equals(name)) {
                type.getInternalConstVars().add((Object)this.parseVarDeclaration());
                return true;
            }
            return false;
        });
    }

    private void parseInternalFB(BaseFBType type) throws TypeImportException, XMLStreamException {
        FB fb = LibraryElementFactory.eINSTANCE.createFB();
        this.readNameCommentAttributes(fb);
        String typeFbElement = this.getAttributeValue("Type");
        FBTypeEntry entry = this.getTypeEntry(typeFbElement, this.getTypeLibrary()::getFBTypeEntry);
        if (entry == null) {
            fb.setTypeEntry(this.addDependency(this.getTypeLibrary().createErrorTypeEntry(typeFbElement, LibraryElementPackage.eINSTANCE.getFBType())));
            fb.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        } else {
            fb.setTypeEntry(entry);
            InterfaceList typeInterface = entry.getInterface();
            fb.setInterface(typeInterface != null ? typeInterface.copy() : LibraryElementFactory.eINSTANCE.createInterfaceList());
        }
        type.getInternalFbs().add((Object)fb);
        this.parseFBChildren(fb, "FB");
    }

    private static FBType convertToBasicType(FBType type) {
        BasicFBType basicType = LibraryElementFactory.eINSTANCE.createBasicFBType();
        FBTImporter.copyGeneralTypeInformation(basicType, type);
        return basicType;
    }

    private static FBType convertToSimpleType(FBType type) {
        SimpleFBType simpleType = LibraryElementFactory.eINSTANCE.createSimpleFBType();
        FBTImporter.copyGeneralTypeInformation(simpleType, type);
        return simpleType;
    }
}

