/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class AttributeTypeExporter
extends AbstractTypeExporter {
    public AttributeTypeExporter(AttributeDeclaration type) {
        super(type);
    }

    @Override
    public AttributeDeclaration getType() {
        return (AttributeDeclaration)super.getType();
    }

    @Override
    protected String getRootTag() {
        return "AttributeDeclaration";
    }

    @Override
    protected void createTypeSpecificXMLEntries() throws XMLStreamException {
        this.addCompilerInfo(this.getType().getCompilerInfo());
        AnyDerivedType anyDerivedType = this.getType().getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType struct = (StructuredType)anyDerivedType;
            this.createStructContent(struct);
        } else {
            AnyDerivedType anyDerivedType2 = this.getType().getType();
            if (anyDerivedType2 instanceof DirectlyDerivedType) {
                DirectlyDerivedType ddt = (DirectlyDerivedType)anyDerivedType2;
                this.createDirectlyDerivedTypeContent(ddt);
            }
        }
        if (!this.getType().getAttributes().isEmpty()) {
            this.addAttributes((EList<Attribute>)this.getType().getAttributes());
        }
    }

    private void createDirectlyDerivedTypeContent(DirectlyDerivedType type) throws XMLStreamException {
        this.addEmptyStartElement("DirectlyDerivedType");
        this.getWriter().writeAttribute("BaseType", PackageNameHelper.getFullTypeName(type.getBaseType()));
        this.getWriter().writeAttribute("InitialValue", type.getInitialValue());
        this.getWriter().writeAttribute("Comment", type.getComment());
    }

    private void createStructContent(StructuredType type) throws XMLStreamException {
        this.addStartElement("StructuredType");
        for (VarDeclaration varDecl : type.getMemberVariables()) {
            this.addVarDeclaration(varDecl);
        }
        this.addEndElement();
    }
}

